/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve.reference;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageExtension;
import ksp.com.intellij.lang.MetaLanguage;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.extensions.ExtensionPointListener;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.project.IndexNotReadyException;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.openapi.util.registry.Registry;
import ksp.com.intellij.patterns.ElementPattern;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.PsiReferenceContributor;
import ksp.com.intellij.psi.PsiReferenceProvider;
import ksp.com.intellij.psi.PsiReferenceProviderBean;
import ksp.com.intellij.psi.PsiReferenceService;
import ksp.com.intellij.psi.PsiReferencesWrapper;
import ksp.com.intellij.psi.ReferenceRange;
import ksp.com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import ksp.com.intellij.psi.impl.source.resolve.reference.PsiReferenceRegistrarImpl;
import ksp.com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import ksp.com.intellij.psi.impl.source.resolve.reference.TrackingReferenceRegistrar;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.IdempotenceChecker;
import ksp.com.intellij.util.KeyedLazyInstance;
import ksp.com.intellij.util.ProcessingContext;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import ksp.it.unimi.dsi.fastutil.doubles.Double2ObjectMaps;
import ksp.it.unimi.dsi.fastutil.doubles.Double2ObjectOpenHashMap;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ReferenceProvidersRegistryImpl
extends ReferenceProvidersRegistry {
    private static final LanguageExtension<PsiReferenceContributor> CONTRIBUTOR_EXTENSION = new LanguageExtension<PsiReferenceContributor>(PsiReferenceContributor.EP_NAME);
    private static final LanguageExtension<PsiReferenceProviderBean> REFERENCE_PROVIDER_EXTENSION = new LanguageExtension(PsiReferenceProviderBean.EP_NAME.getName());
    private final Map<Language, PsiReferenceRegistrarImpl> myRegistrars = new ConcurrentHashMap<Language, PsiReferenceRegistrarImpl>();

    public ReferenceProvidersRegistryImpl() {
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(PsiReferenceContributor.EP_NAME)) {
            PsiReferenceContributor.EP_NAME.addExtensionPointListener(new ExtensionPointListener<KeyedLazyInstance<PsiReferenceContributor>>(){

                @Override
                public void extensionAdded(@NotNull KeyedLazyInstance<PsiReferenceContributor> extension, @NotNull PluginDescriptor pluginDescriptor) {
                    block6: {
                        PsiReferenceContributor instance2;
                        Language language;
                        block5: {
                            if (extension == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (pluginDescriptor == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            language = Language.findLanguageByID(extension.getKey());
                            instance2 = extension.getInstance();
                            if (language != Language.ANY) break block5;
                            for (PsiReferenceRegistrarImpl registrar2 : ReferenceProvidersRegistryImpl.this.myRegistrars.values()) {
                                ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar2, instance2);
                            }
                            break block6;
                        }
                        if (language == null) break block6;
                        this.registerContributorForLanguageAndDialects(language, instance2);
                        if (language instanceof MetaLanguage) {
                            Collection<Language> matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
                            for (Language matchingLanguage : matchingLanguages) {
                                this.registerContributorForLanguageAndDialects(matchingLanguage, instance2);
                            }
                        }
                    }
                }

                private void registerContributorForLanguageAndDialects(@NotNull Language language, @NotNull PsiReferenceContributor instance2) {
                    PsiReferenceRegistrarImpl registrar2;
                    if (language == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (instance2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if ((registrar2 = (PsiReferenceRegistrarImpl)ReferenceProvidersRegistryImpl.this.myRegistrars.get(language)) != null) {
                        ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar2, instance2);
                    }
                    for (Language dialect : language.getTransitiveDialects()) {
                        registrar2 = (PsiReferenceRegistrarImpl)ReferenceProvidersRegistryImpl.this.myRegistrars.get(dialect);
                        if (registrar2 == null) continue;
                        ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar2, instance2);
                    }
                }

                @Override
                public void extensionRemoved(@NotNull KeyedLazyInstance<PsiReferenceContributor> extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    Disposer.dispose(extension.getInstance());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "extension";
                            break;
                        }
                        case 1: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "pluginDescriptor";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "language";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "instance";
                            break;
                        }
                    }
                    objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionAdded";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "registerContributorForLanguageAndDialects";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extensionRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, null);
        }
    }

    @NotNull
    private static PsiReferenceRegistrarImpl createRegistrar(@NotNull Language language) {
        if (language == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(0);
        }
        PsiReferenceRegistrarImpl registrar2 = new PsiReferenceRegistrarImpl();
        for (PsiReferenceContributor contributor : CONTRIBUTOR_EXTENSION.allForLanguageOrAny(language)) {
            ReferenceProvidersRegistryImpl.registerContributedReferenceProviders(registrar2, contributor);
        }
        List<PsiReferenceProviderBean> referenceProviderBeans = REFERENCE_PROVIDER_EXTENSION.allForLanguageOrAny(language);
        for (final PsiReferenceProviderBean providerBean : referenceProviderBeans) {
            ElementPattern<PsiElement> pattern = providerBean.createElementPattern();
            if (pattern == null) continue;
            registrar2.registerReferenceProvider(pattern, new PsiReferenceProvider(){
                PsiReferenceProvider myProvider;

                @Override
                public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
                    if (element2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (context2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (this.myProvider == null) {
                        this.myProvider = providerBean.instantiate();
                        if (this.myProvider == null) {
                            this.myProvider = ReferenceProvidersRegistry.NULL_REFERENCE_PROVIDER;
                        }
                    }
                    PsiReference[] psiReferenceArray = this.myProvider.getReferencesByElement(element2, context2);
                    if (psiReferenceArray == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 2: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "ksp/com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$2";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl$2";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getReferencesByElement";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getReferencesByElement";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        registrar2.markInitialized();
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = registrar2;
        if (psiReferenceRegistrarImpl == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(1);
        }
        return psiReferenceRegistrarImpl;
    }

    private static void registerContributedReferenceProviders(@NotNull PsiReferenceRegistrarImpl registrar2, @NotNull PsiReferenceContributor contributor) {
        if (registrar2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(2);
        }
        if (contributor == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(3);
        }
        contributor.registerReferenceProviders(new TrackingReferenceRegistrar(registrar2, contributor));
        Disposer.register(ApplicationManager.getApplication(), contributor);
    }

    @Override
    @NotNull
    public PsiReferenceRegistrarImpl getRegistrar(@NotNull Language language) {
        if (language == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(4);
        }
        PsiReferenceRegistrarImpl psiReferenceRegistrarImpl = this.myRegistrars.computeIfAbsent(language, ReferenceProvidersRegistryImpl::createRegistrar);
        if (psiReferenceRegistrarImpl == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceRegistrarImpl;
    }

    @Override
    public void unloadProvidersFor(@NotNull Language language) {
        PsiReferenceRegistrarImpl psiReferenceRegistrar;
        if (language == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(6);
        }
        if ((psiReferenceRegistrar = this.myRegistrars.remove(language)) != null) {
            psiReferenceRegistrar.cleanup();
        }
        for (PsiReferenceRegistrarImpl registrar2 : this.myRegistrars.values()) {
            registrar2.clearBindingsCache();
        }
    }

    @Override
    protected PsiReference @NotNull [] doGetReferencesFromProviders(@NotNull PsiElement context2, @NotNull PsiReferenceService.Hints hints) {
        List<ProviderBinding.ProviderInfo<ProcessingContext>> providers;
        Double2ObjectMap<List<PsiReference[]>> allReferencesMap;
        if (context2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(7);
        }
        if (hints == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(8);
        }
        if ((allReferencesMap = ReferenceProvidersRegistryImpl.mapNotEmptyReferencesFromProviders(context2, providers = this.getRegistrar(context2.getLanguage()).getPairsByElement(context2, hints))).isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(9);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        double maxPriority = Math.max(-100.0, ArrayUtil.max(allReferencesMap.keySet().toDoubleArray()));
        List<PsiReference> maxPriorityRefs = ReferenceProvidersRegistryImpl.collectReferences((Collection)allReferencesMap.get(maxPriority));
        ContainerUtil.addAllNotNull(result2, maxPriorityRefs);
        ContainerUtil.addAllNotNull(result2, ReferenceProvidersRegistryImpl.getLowerPriorityReferences(allReferencesMap, maxPriority, maxPriorityRefs));
        PsiReference[] psiReferenceArray = result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    @NotNull
    private static Double2ObjectMap<List<PsiReference[]>> mapNotEmptyReferencesFromProviders(@NotNull PsiElement context2, @NotNull List<? extends ProviderBinding.ProviderInfo<ProcessingContext>> providers) {
        if (context2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(11);
        }
        if (providers == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(12);
        }
        Double2ObjectOpenHashMap<List<PsiReference[]>> map = new Double2ObjectOpenHashMap<List<PsiReference[]>>();
        for (ProviderBinding.ProviderInfo<ProcessingContext> providerInfo : providers) {
            Object[] refs = ReferenceProvidersRegistryImpl.getReferences(context2, providerInfo);
            if (refs.length <= 0) continue;
            List<PsiReference[]> list = map.get(providerInfo.priority);
            if (list == null) {
                list = new SmartList<PsiReference[]>();
                map.put(providerInfo.priority, list);
            }
            list.add((PsiReference[])refs);
            if (!IdempotenceChecker.isLoggingEnabled()) continue;
            IdempotenceChecker.logTrace(providerInfo.provider + " returned " + Arrays.toString(refs));
        }
        Double2ObjectOpenHashMap<List<PsiReference[]>> double2ObjectOpenHashMap = map;
        if (double2ObjectOpenHashMap == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(13);
        }
        return double2ObjectOpenHashMap;
    }

    private static PsiReference @NotNull [] getReferences(@NotNull PsiElement context2, @NotNull ProviderBinding.ProviderInfo<? extends ProcessingContext> providerInfo) {
        PsiReference[] psiReferenceArray;
        if (context2 == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(14);
        }
        if (providerInfo == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(15);
        }
        try {
            psiReferenceArray = providerInfo.provider.getReferencesByElement(context2, (ProcessingContext)providerInfo.processingContext);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(17);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(16);
        }
        return psiReferenceArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static List<PsiReference> getLowerPriorityReferences(@NotNull Double2ObjectMap<List<PsiReference[]>> allReferencesMap, double maxPriority, @NotNull List<? extends PsiReference> list) {
        if (allReferencesMap == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(18);
        }
        if (list == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(19);
        }
        SmartList<PsiReference> result2 = new SmartList<PsiReference>();
        for (Double2ObjectMap.Entry entry : Double2ObjectMaps.fastIterable(allReferencesMap)) {
            if (maxPriority == entry.getDoubleKey()) continue;
            for (PsiReference[] references : (List)entry.getValue()) {
                void maxPriorityRefs;
                if (!ReferenceProvidersRegistryImpl.haveNotIntersectedTextRanges((List<? extends PsiReference>)maxPriorityRefs, references)) continue;
                ContainerUtil.addAllNotNull(result2, references);
            }
        }
        SmartList<PsiReference> smartList = result2;
        if (smartList == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    private static boolean haveNotIntersectedTextRanges(@NotNull List<? extends PsiReference> higherPriorityRefs, PsiReference @NotNull [] lowerPriorityRefs) {
        if (higherPriorityRefs == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(21);
        }
        if (lowerPriorityRefs == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(22);
        }
        for (PsiReference ref : lowerPriorityRefs) {
            if (ref == null) continue;
            for (PsiReference psiReference : higherPriorityRefs) {
                if (psiReference instanceof PsiReferencesWrapper || psiReference == null || !ReferenceRange.containsRangeInElement(psiReference, ref.getRangeInElement())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static List<PsiReference> collectReferences(@Nullable Collection<PsiReference[]> references) {
        if (references == null) {
            List<PsiReference> list = Collections.emptyList();
            if (list == null) {
                ReferenceProvidersRegistryImpl.$$$reportNull$$$0(23);
            }
            return list;
        }
        SmartList<PsiReference> list = new SmartList<PsiReference>();
        for (PsiReference[] reference2 : references) {
            ContainerUtil.addAllNotNull(list, reference2);
        }
        SmartList<PsiReference> smartList = list;
        if (smartList == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    @Deprecated
    public static void disableUnderlyingElementChecks(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ReferenceProvidersRegistryImpl.$$$reportNull$$$0(25);
        }
        Registry.get("ide.check.reference.provider.underlying.element").setValue(false, parentDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allReferencesMap";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxPriorityRefs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "higherPriorityRefs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowerPriorityRefs";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/resolve/reference/ReferenceProvidersRegistryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRegistrar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrar";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetReferencesFromProviders";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotEmptyReferencesFromProviders";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowerPriorityReferences";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferences";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRegistrar";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerContributedReferenceProviders";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrar";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unloadProvidersFor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doGetReferencesFromProviders";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mapNotEmptyReferencesFromProviders";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLowerPriorityReferences";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "haveNotIntersectedTextRanges";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "disableUnderlyingElementChecks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

