/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.types.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.KtVariableDeclaration;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import ksp.org.jetbrains.kotlin.resolve.LocalVariableResolver;
import ksp.org.jetbrains.kotlin.resolve.TypeResolver;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import ksp.org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import ksp.org.jetbrains.kotlin.types.error.ErrorType;
import ksp.org.jetbrains.kotlin.types.error.ErrorTypeKind;
import ksp.org.jetbrains.kotlin.types.error.ErrorUtils;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import ksp.org.jetbrains.kotlin.types.expressions.FakeCallKind;
import ksp.org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J2\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J4\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lksp/org/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver;", "", "fakeCallResolver", "Lksp/org/jetbrains/kotlin/types/expressions/FakeCallResolver;", "localVariableResolver", "Lksp/org/jetbrains/kotlin/resolve/LocalVariableResolver;", "typeResolver", "Lksp/org/jetbrains/kotlin/resolve/TypeResolver;", "<init>", "(Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "resolveLocalVariablesFromDestructuringDeclaration", "", "Lksp/org/jetbrains/kotlin/descriptors/VariableDescriptor;", "scope", "Lksp/org/jetbrains/kotlin/resolve/scopes/LexicalScope;", "destructuringDeclaration", "Lksp/org/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "receiver", "Lksp/org/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "initializer", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "context", "Lksp/org/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "defineLocalVariablesFromDestructuringDeclaration", "", "writableScope", "Lksp/org/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "resolveInitializer", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "entry", "Lksp/org/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "componentIndex", "", "resolveComponentFunctionAndGetType", "componentName", "Lksp/org/jetbrains/kotlin/name/Name;", "getExpectedTypeForComponent", "frontend"})
@SourceDebugExtension(value={"SMAP\nDestructuringDeclarationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DestructuringDeclarationResolver.kt\norg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1869#2,2:132\n*S KotlinDebug\n*F\n+ 1 DestructuringDeclarationResolver.kt\norg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver\n*L\n74#1:132,2\n*E\n"})
public final class DestructuringDeclarationResolver {
    @NotNull
    private final FakeCallResolver fakeCallResolver;
    @NotNull
    private final LocalVariableResolver localVariableResolver;
    @NotNull
    private final TypeResolver typeResolver;

    public DestructuringDeclarationResolver(@NotNull FakeCallResolver fakeCallResolver, @NotNull LocalVariableResolver localVariableResolver, @NotNull TypeResolver typeResolver) {
        Intrinsics.checkNotNullParameter((Object)fakeCallResolver, (String)"fakeCallResolver");
        Intrinsics.checkNotNullParameter((Object)localVariableResolver, (String)"localVariableResolver");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        this.fakeCallResolver = fakeCallResolver;
        this.localVariableResolver = localVariableResolver;
        this.typeResolver = typeResolver;
    }

    @NotNull
    public final List<VariableDescriptor> resolveLocalVariablesFromDestructuringDeclaration(@NotNull LexicalScope scope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ArrayList<LocalVariableDescriptor> result2 = new ArrayList<LocalVariableDescriptor>();
        Iterator iterator2 = ((Iterable)destructuringDeclaration.getEntries()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int componentIndex = n2++;
            KtDestructuringDeclarationEntry entry = (KtDestructuringDeclarationEntry)iterator2.next();
            Intrinsics.checkNotNull((Object)entry);
            KotlinType componentType = this.resolveInitializer(entry, receiver, initializer, context2, componentIndex);
            KtVariableDeclaration ktVariableDeclaration = entry;
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
            LocalVariableDescriptor variableDescriptor = this.localVariableResolver.resolveLocalVariableDescriptorWithType$frontend(scope, ktVariableDeclaration, componentType, bindingTrace);
            result2.add(variableDescriptor);
        }
        PsiElement psiElement = destructuringDeclaration.getTrailingComma();
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        LanguageVersionSettings languageVersionSettings = context2.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"languageVersionSettings");
        TrailingCommaChecker.INSTANCE.check(psiElement, bindingTrace, languageVersionSettings);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final void defineLocalVariablesFromDestructuringDeclaration(@NotNull LexicalWritableScope writableScope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer, @NotNull ExpressionTypingContext context2) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)writableScope, (String)"writableScope");
        Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterable iterable = this.resolveLocalVariablesFromDestructuringDeclaration(writableScope, destructuringDeclaration, receiver, initializer, context2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariableDescriptor it = (VariableDescriptor)element$iv;
            boolean bl2 = false;
            ExpressionTypingUtils.checkVariableShadowing(writableScope, context2.trace, it);
            writableScope.addVariableDescriptor(it);
        }
    }

    @NotNull
    public final KotlinType resolveInitializer(@NotNull KtDestructuringDeclarationEntry entry, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer, @NotNull ExpressionTypingContext context2, int componentIndex) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Name componentName = DataClassDescriptorResolver.INSTANCE.createComponentName(componentIndex + 1);
        return this.resolveComponentFunctionAndGetType(componentName, context2, entry, receiver, initializer);
    }

    private final KotlinType resolveComponentFunctionAndGetType(Name componentName, ExpressionTypingContext context2, KtDestructuringDeclarationEntry entry, ReceiverValue receiver, KtExpression initializer) {
        KotlinType kotlinType;
        OverloadResolutionResults<FunctionDescriptor> results;
        if (receiver == null) {
            return DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        KotlinType expectedType = this.getExpectedTypeForComponent(context2, entry);
        Object Context2 = ((ExpressionTypingContext)context2.replaceExpectedType(expectedType)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceContextDependency(...)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)Context2;
        ResolutionContext resolutionContext = newContext;
        KtExpression ktExpression = entry;
        KtExpression ktExpression2 = initializer;
        if (ktExpression2 == null) {
            ktExpression2 = entry;
        }
        if (!(results = this.fakeCallResolver.resolveFakeCall(resolutionContext, receiver, componentName, ktExpression, ktExpression2, FakeCallKind.COMPONENT, CollectionsKt.emptyList())).isSuccess()) {
            return DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        context2.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
        KotlinType functionReturnType = results.getResultingDescriptor().getReturnType();
        if (functionReturnType != null && !TypeUtils.noExpectedType(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(functionReturnType, expectedType)) {
            BindingTrace bindingTrace = context2.trace;
            KtExpression ktExpression3 = initializer;
            if (ktExpression3 == null) {
                ktExpression3 = entry;
            }
            bindingTrace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)ktExpression3), componentName, functionReturnType, expectedType));
        }
        if ((kotlinType = functionReturnType) == null) {
            kotlinType = DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        return kotlinType;
    }

    private final KotlinType getExpectedTypeForComponent(ExpressionTypingContext context2, KtDestructuringDeclarationEntry entry) {
        KtTypeReference ktTypeReference = entry.getTypeReference();
        if (ktTypeReference == null) {
            SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
            return simpleType;
        }
        KtTypeReference entryTypeRef = ktTypeReference;
        LexicalScope lexicalScope = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        return this.typeResolver.resolveType(lexicalScope, entryTypeRef, bindingTrace, true);
    }

    private static final ErrorType resolveComponentFunctionAndGetType$errorType(Name $componentName) {
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)$componentName.toString(), (String)"toString(...)");
        return ErrorUtils.createErrorType(ErrorTypeKind.ERROR_TYPE_FOR_DESTRUCTURING_COMPONENT, stringArray);
    }
}

