/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirImport;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedParentInImport;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "<init>", "()V", "checkPsiOrLightTree", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "element", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/KtSourceElement;)V", "processPossiblyUnresolvedImport", "import", "Lksp/org/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;)V", "getOutermostClassName", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "isClassIdPointingToEnumEntry", "", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "classId", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnresolvedInMiddleOfImportChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnresolvedInMiddleOfImportChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1#2:104\n84#3:105\n37#4:106\n1761#5,3:107\n*S KotlinDebug\n*F\n+ 1 FirUnresolvedInMiddleOfImportChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnresolvedInMiddleOfImportChecker\n*L\n99#1:105\n99#1:106\n100#1:107,3\n*E\n"})
public final class FirUnresolvedInMiddleOfImportChecker
extends FirDeclarationSyntaxChecker<FirFile, KtFile> {
    @NotNull
    public static final FirUnresolvedInMiddleOfImportChecker INSTANCE = new FirUnresolvedInMiddleOfImportChecker();

    private FirUnresolvedInMiddleOfImportChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFile element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        for (FirImport firImport : element2.getImports()) {
            if (!(firImport instanceof FirResolvedImport)) continue;
            this.processPossiblyUnresolvedImport(context2, reporter, (FirResolvedImport)firImport);
        }
    }

    private final void processPossiblyUnresolvedImport(CheckerContext context2, DiagnosticReporter reporter, FirResolvedImport firResolvedImport) {
        Object object = firResolvedImport.getSource();
        boolean bl2 = object != null && (object = ((KtSourceElement)object).getKind()) != null ? ((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false;
        if (bl2) {
            return;
        }
        ClassId classId = firResolvedImport.getResolvedParentClassId();
        if (classId == null) {
            return;
        }
        ClassId referencedClass = classId;
        PackageResolutionResult importResolutionResult = ImportUtilsKt.resolveToPackageOrClass(FirSymbolProviderKt.getSymbolProvider(context2.getSession()), referencedClass);
        if (!(importResolutionResult instanceof PackageResolutionResult.Error)) {
            return;
        }
        ConeDiagnostic diagnostic = ((PackageResolutionResult.Error)importResolutionResult).getDiagnostic();
        if (diagnostic instanceof ConeUnresolvedParentInImport) {
            KtSourceElement ktSourceElement = firResolvedImport.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source = ktSourceElement;
            ClassId parentClassId = ((ConeUnresolvedParentInImport)diagnostic).getParentClassId();
            if (firResolvedImport.isAllUnder() && this.isClassIdPointingToEnumEntry(context2.getSession(), parentClassId)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), (Object)parentClassId.getShortClassName(), null, 16, null);
                return;
            }
            int errorSegmentIndexFromLast = firResolvedImport.isAllUnder() ? 0 : 1;
            ClassId currentClassId = parentClassId.getParentClassId();
            while (currentClassId != null && FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId(currentClassId) == null) {
                currentClassId = currentClassId.getParentClassId();
                ++errorSegmentIndexFromLast;
            }
            KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getSourceForImportSegment(firResolvedImport, errorSegmentIndexFromLast);
            if (ktSourceElement2 == null) {
                return;
            }
            KtSourceElement unresolvedSource = ktSourceElement2;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)unresolvedSource, FirErrors.INSTANCE.getUNRESOLVED_IMPORT(), (Object)this.getOutermostClassName(parentClassId), null, 16, null);
        }
    }

    private final String getOutermostClassName(ClassId $this$getOutermostClassName) {
        String string = ((Name)CollectionsKt.first($this$getOutermostClassName.getRelativeClassName().pathSegments())).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private final boolean isClassIdPointingToEnumEntry(FirSession session, ClassId classId) {
        boolean bl2;
        block8: {
            Object object;
            block10: {
                block9: {
                    ClassId classId2 = classId.getParentClassId();
                    if (classId2 == null) {
                        return false;
                    }
                    ClassId enumClassId = classId2;
                    FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(session).getClassLikeSymbolByClassId(enumClassId);
                    object = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                    if (object == null) break block9;
                    Object object2 = object;
                    FirRegularClassSymbol it = object2;
                    boolean bl3 = false;
                    FirClassSymbol $this$isEnumClass$iv = it;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    object = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS ? object2 : null;
                    if (object != null) break block10;
                }
                return false;
            }
            FirRegularClassSymbol enumClass = object;
            Iterable $this$any$iv = DeclarationUtilsKt.collectEnumEntries(enumClass, session);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getCallableId().getCallableName(), (Object)classId.getShortClassName())) continue;
                    bl2 = true;
                    break block8;
                }
                bl2 = false;
            }
        }
        return bl2;
    }
}

