/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.platform.projectStructure;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiDirectory;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaDanglingFileModuleImpl;
import ksp.org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileResolutionMode;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import ksp.org.jetbrains.kotlin.idea.KotlinLanguage;
import ksp.org.jetbrains.kotlin.psi.KtCodeFragment;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProviderBase;", "Lksp/org/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProvider;", "<init>", "()V", "getNotUnderContentRootModule", "Lksp/org/jetbrains/kotlin/analysis/api/projectStructure/KaNotUnderContentRootModule;", "project", "Lksp/com/intellij/openapi/project/Project;", "computeSpecialModule", "Lksp/org/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "file", "Lksp/com/intellij/psi/PsiFile;", "computeDefaultDanglingFileResolutionMode", "Lksp/org/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "computeContextModule", "isSupportedContextElement", "", "context", "Lksp/com/intellij/psi/PsiElement;", "analysis-api-platform-interface"})
@SourceDebugExtension(value={"SMAP\nKotlinProjectStructureProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectStructureProviderBase.kt\norg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProviderBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public abstract class KotlinProjectStructureProviderBase
implements KotlinProjectStructureProvider {
    @NotNull
    protected abstract KaNotUnderContentRootModule getNotUnderContentRootModule(@NotNull Project var1);

    @Nullable
    protected final KaModule computeSpecialModule(@NotNull PsiFile file) {
        KaModule contextModule;
        KaModule explicitModule;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file instanceof KtFile && (explicitModule = DanglingFilesKt.getExplicitModule((KtFile)file)) != null) {
            return explicitModule;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (contextModule = ContextModuleKt.getAnalysisContextModule(virtualFile)) != null) {
            return contextModule;
        }
        if (file instanceof KtFile && DanglingFilesKt.isDangling((KtFile)file)) {
            contextModule = this.computeContextModule((KtFile)file);
            KaDanglingFileResolutionMode kaDanglingFileResolutionMode = DanglingFilesKt.getDanglingFileResolutionMode((KtFile)file);
            if (kaDanglingFileResolutionMode == null) {
                kaDanglingFileResolutionMode = this.computeDefaultDanglingFileResolutionMode((KtFile)file);
            }
            KaDanglingFileResolutionMode resolutionMode = kaDanglingFileResolutionMode;
            return new KaDanglingFileModuleImpl(CollectionsKt.listOf((Object)file), contextModule, resolutionMode);
        }
        return null;
    }

    private final KaDanglingFileResolutionMode computeDefaultDanglingFileResolutionMode(KtFile file) {
        if (!file.isPhysical() && !file.getViewProvider().isEventSystemEnabled() && DanglingFilesKt.getCopyOrigin(file) != null) {
            return KaDanglingFileResolutionMode.IGNORE_SELF;
        }
        return KaDanglingFileResolutionMode.PREFER_SELF;
    }

    private final KaModule computeContextModule(KtFile file) {
        PsiElement contextElement;
        PsiElement psiElement;
        block11: {
            PsiElement psiElement2;
            PsiFile originalFile;
            block10: {
                PsiElement psiElement3;
                KaModule kaModule;
                Object object;
                originalFile = DanglingFilesKt.getCopyOrigin(file);
                if (originalFile != null && (object = originalFile.getVirtualFile()) != null && (kaModule = ContextModuleKt.getAnalysisContextModule((VirtualFile)object)) != null) {
                    KaModule it = kaModule;
                    boolean bl2 = false;
                    return it;
                }
                object = DanglingFilesKt.getContextModule(file);
                if (object != null) {
                    Object it = object;
                    boolean bl3 = false;
                    return it;
                }
                psiElement = file.getContext();
                if (psiElement == null) break block10;
                PsiElement p0 = psiElement3 = psiElement;
                boolean bl4 = false;
                psiElement = this.isSupportedContextElement(p0) ? psiElement3 : null;
                if (psiElement != null) break block11;
            }
            PsiElement psiElement4 = KtPsiFactoryKt.getAnalysisContext(file);
            if (psiElement4 != null) {
                PsiElement psiElement5;
                PsiElement p0 = psiElement5 = psiElement4;
                boolean bl5 = false;
                psiElement2 = this.isSupportedContextElement(p0) ? psiElement5 : null;
            } else {
                psiElement2 = psiElement = null;
            }
            if (psiElement2 == null) {
                psiElement = originalFile;
            }
        }
        if ((contextElement = psiElement) != null) {
            KaModule contextModule = this.getModule(contextElement, null);
            if (contextModule instanceof KaDanglingFileModule && !(file instanceof KtCodeFragment)) {
                return DanglingFilesKt.getBaseContextModule((KaDanglingFileModule)contextModule);
            }
            return contextModule;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.getNotUnderContentRootModule(project);
    }

    private final boolean isSupportedContextElement(PsiElement context2) {
        return Intrinsics.areEqual((Object)context2.getLanguage(), (Object)KotlinLanguage.INSTANCE) || context2 instanceof PsiDirectory;
    }
}

