/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.backend.ast;

import ksp.org.jetbrains.kotlin.js.backend.ast.JsOperator;

public enum JsUnaryOperator implements JsOperator
{
    BIT_NOT("~", 14, 8),
    DEC("--", 14, 12),
    DELETE("delete", 14, 8),
    INC("++", 14, 12),
    NEG("-", 14, 8),
    POS("+", 14, 8),
    NOT("!", 14, 8),
    TYPEOF("typeof", 14, 8),
    VOID("void", 14, 8);

    private final int mask;
    private final int precedence;
    private final String symbol;

    private JsUnaryOperator(String symbol, int precedence, int mask) {
        this.symbol = symbol;
        this.precedence = precedence;
        this.mask = mask;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isKeyword() {
        return this == DELETE || this == TYPEOF || this == VOID;
    }

    @Override
    public boolean isLeftAssociative() {
        return (this.mask & 1) != 0;
    }

    public boolean isModifying() {
        return this == DEC || this == INC || this == DELETE;
    }

    public String toString() {
        return this.symbol;
    }
}

