/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import ksp.com.intellij.psi.stubs.Hash;

final class StrippedIntOpenHashMap {
    private transient int[] key;
    private transient int[] value;
    private transient int mask;
    private transient boolean containsNull;
    private transient int nullValue;
    private transient int n;
    private transient int maxFill;
    private final transient int minN;
    private int size;
    private final float f;

    private StrippedIntOpenHashMap(int expected, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.minN = this.n = Hash.arraySize(expected, f2);
        this.mask = this.n - 1;
        this.maxFill = Hash.maxFill(this.n, f2);
        this.key = new int[this.n + 1];
        this.value = new int[this.n + 1];
    }

    StrippedIntOpenHashMap() {
        this(16, 0.75f);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public void put(int k2, int v2) {
        assert (v2 != 0);
        int[] key = this.key;
        if (k2 == 0) {
            this.nullValue = v2;
            this.containsNull = true;
        } else {
            int pos = Hash.mix(k2) & this.mask;
            int curr = key[pos];
            if (curr != 0) {
                if (curr == k2) {
                    this.value[pos] = v2;
                    return;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0) {
                    if (curr != k2) continue;
                    this.value[pos] = v2;
                    return;
                }
            }
            key[pos] = k2;
            this.value[pos] = v2;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(Hash.arraySize(this.size + 1, this.f));
        }
        assert (this.get(k2, -1) == v2 && this.get(k2, 0) == v2);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void rehash(int newN) {
        int[] key = this.key;
        int[] value2 = this.value;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int[] newValue = new int[newN + 1];
        int i2 = this.n;
        int j2 = this.realSize();
        while (j2-- != 0) {
            while (key[--i2] == 0) {
            }
            int pos = Hash.mix(key[i2]) & mask;
            if (newKey[pos] != 0) {
                while (newKey[pos = pos + 1 & mask] != 0) {
                }
            }
            newKey[pos] = key[i2];
            newValue[pos] = value2[i2];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = Hash.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        for (i2 = 0; i2 < key.length; ++i2) {
            int k2 = key[i2];
            int v2 = value2[i2];
            assert (k2 == 0 || this.get(k2, -1) == v2);
        }
    }

    public int get(int k2, int absentValue) {
        if (k2 == 0) {
            return this.containsNull ? this.nullValue : absentValue;
        }
        int[] key = this.key;
        int pos = Hash.mix(k2) & this.mask;
        int curr = this.value[pos];
        if (curr == 0) {
            return absentValue;
        }
        if (k2 == key[pos]) {
            return curr;
        }
        do {
            if ((curr = this.value[pos = pos + 1 & this.mask]) != 0) continue;
            return absentValue;
        } while (k2 != key[pos]);
        return curr;
    }
}

