/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtFunctionType;
import ksp.org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import ksp.org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"checkClassifierUsages", "", "declarations", "", "Lksp/com/intellij/psi/PsiElement;", "checkers", "", "Lksp/org/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
public final class ClassifierUsageCheckerKt {
    public static final void checkClassifierUsages(@NotNull Collection<? extends PsiElement> declarations2, @NotNull Iterable<? extends ClassifierUsageChecker> checkers, @NotNull ClassifierUsageCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        Intrinsics.checkNotNullParameter(checkers, (String)"checkers");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtTreeVisitorVoid visitor2 = new KtTreeVisitorVoid(context2, checkers){
            final /* synthetic */ ClassifierUsageCheckerContext $context;
            final /* synthetic */ Iterable<ClassifierUsageChecker> $checkers;
            {
                this.$context = $context;
                this.$checkers = $checkers;
            }

            public void visitReferenceExpression(KtReferenceExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitReferenceExpression(expression2);
                if (expression2 instanceof KtNameReferenceExpression && Intrinsics.areEqual((Object)((KtNameReferenceExpression)expression2).getReferencedNameElementType(), (Object)KtTokens.SUPER_KEYWORD)) {
                    return;
                }
                List<ClassifierDescriptor> targets = this.getReferencedClassifiers(expression2);
                for (ClassifierDescriptor target : targets) {
                    this.runCheckersWithTarget(target, expression2);
                }
            }

            public void visitFunctionType(KtFunctionType type2) {
                ClassifierDescriptor descriptor2;
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                super.visitFunctionType(type2);
                PsiElement psiElement = type2.getParent();
                KtTypeReference ktTypeReference = psiElement instanceof KtTypeReference ? (KtTypeReference)psiElement : null;
                if (ktTypeReference == null) {
                    return;
                }
                KotlinType kotlinType = (KotlinType)this.$context.getTrace().get(BindingContext.TYPE, ktTypeReference);
                if (kotlinType != null && (descriptor2 = kotlinType.getConstructor().getDeclarationDescriptor()) != null) {
                    this.runCheckersWithTarget(descriptor2, type2);
                }
            }

            private final void runCheckersWithTarget(ClassifierDescriptor target, KtElement expression2) {
                for (ClassifierUsageChecker checker : this.$checkers) {
                    checker.check(target, expression2, this.$context);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final List<ClassifierDescriptor> getReferencedClassifiers(KtReferenceExpression expression2) {
                List list;
                DeclarationDescriptor target = (DeclarationDescriptor)this.$context.getTrace().get(BindingContext.REFERENCE_TARGET, expression2);
                DeclarationDescriptor declarationDescriptor = target;
                if (declarationDescriptor instanceof ClassifierDescriptor) {
                    Object[] objectArray = new ClassifierDescriptor[]{target, this.getClassifierUsedToReferenceCompanionObject((ClassifierDescriptor)target, expression2)};
                    list = CollectionsKt.listOfNotNull((Object[])objectArray);
                } else if (declarationDescriptor instanceof ClassConstructorDescriptor) {
                    list = CollectionsKt.listOf((Object)((ClassConstructorDescriptor)target).getConstructedClass());
                } else if (declarationDescriptor instanceof FakeCallableDescriptorForTypeAliasObject) {
                    TypeAliasDescriptor referencedTypeAlias;
                    ClassDescriptor referencedObject = ((FakeCallableDescriptorForTypeAliasObject)target).getReferencedObject();
                    if (!Intrinsics.areEqual((Object)referencedObject, (Object)(referencedTypeAlias = ((FakeCallableDescriptorForTypeAliasObject)target).getTypeAliasDescriptor()).getClassDescriptor())) {
                        Object[] objectArray = new ClassifierDescriptorWithTypeParameters[]{referencedObject, referencedTypeAlias};
                        list = CollectionsKt.listOf((Object[])objectArray);
                    } else {
                        list = CollectionsKt.listOf((Object)referencedTypeAlias);
                    }
                } else {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$groupByTo$iv$iv;
                    Collection collection = (Collection)this.$context.getTrace().get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression2);
                    if (collection == null) {
                        return CollectionsKt.emptyList();
                    }
                    Collection targets = collection;
                    Iterable $this$groupBy$iv = targets;
                    boolean $i$f$groupBy = false;
                    Iterable iterable = $this$groupBy$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                        boolean bl2 = false;
                        DeclarationDescriptorWithSource declarationDescriptorWithSource = it instanceof DeclarationDescriptorWithSource ? (DeclarationDescriptorWithSource)it : null;
                        SourceElement key$iv$iv = declarationDescriptorWithSource != null ? declarationDescriptorWithSource.getSource() : null;
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl3 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    if (destination$iv$iv.size() != 1) {
                        return CollectionsKt.emptyList();
                    }
                    Iterable $this$filterIsInstance$iv = targets;
                    boolean $i$f$filterIsInstance = false;
                    destination$iv$iv = $this$filterIsInstance$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ClassifierDescriptor)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List targetClassifiers = (List)destination$iv$iv2;
                    list = targetClassifiers.size() == 1 ? targetClassifiers : CollectionsKt.emptyList();
                }
                return list;
            }

            private final ClassifierDescriptor getClassifierUsedToReferenceCompanionObject(ClassifierDescriptor referencedObject, KtReferenceExpression expression2) {
                return DescriptorUtilsKt.isCompanionObject(referencedObject) ? (ClassifierDescriptor)this.$context.getTrace().get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, expression2) : null;
            }
        };
        for (PsiElement psiElement : declarations2) {
            psiElement.accept(visitor2);
        }
    }
}

