/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ArgumentTypeMismatch;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ConeLambdaWithTypeVariableAsExpectedTypeAtom;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ConePostponedResolvedAtom;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import ksp.org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleterKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import ksp.org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import ksp.org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import ksp.org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\u00020\u0005*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/stages/CheckLambdaAgainstTypeVariableContradiction;", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "callInfo", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "sink", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "context", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkForContradiction", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ConeLambdaWithTypeVariableAsExpectedTypeAtom;", "csBuilder", "Lksp/org/jetbrains/kotlin/resolve/calls/inference/model/NewConstraintSystemImpl;", "hasFunctionTypeConstraint", "", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckLambdaAgainstTypeVariableContradiction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1053:1\n1761#2,3:1054\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckLambdaAgainstTypeVariableContradiction\n*L\n1050#1:1054,3\n*E\n"})
public final class CheckLambdaAgainstTypeVariableContradiction
extends ResolutionStage {
    @NotNull
    public static final CheckLambdaAgainstTypeVariableContradiction INSTANCE = new CheckLambdaAgainstTypeVariableContradiction();

    private CheckLambdaAgainstTypeVariableContradiction() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.CheckLambdaAgainstTypeVariableContradictionInResolution)) {
            return Unit.INSTANCE;
        }
        NewConstraintSystemImpl csBuilder = ConstraintSystemCompleterKt.getCsBuilder(candidate);
        if (csBuilder.getHasContradiction()) {
            return Unit.INSTANCE;
        }
        for (ConePostponedResolvedAtom postponedAtom : candidate.getPostponedAtoms()) {
            if (!(postponedAtom instanceof ConeLambdaWithTypeVariableAsExpectedTypeAtom)) continue;
            this.checkForContradiction((ConeLambdaWithTypeVariableAsExpectedTypeAtom)postponedAtom, csBuilder, context2, sink);
        }
        return Unit.INSTANCE;
    }

    private final void checkForContradiction(ConeLambdaWithTypeVariableAsExpectedTypeAtom $this$checkForContradiction, NewConstraintSystemImpl csBuilder, ResolutionContext context2, CheckerSink sink) {
        if (this.hasFunctionTypeConstraint($this$checkForContradiction, csBuilder, context2)) {
            return;
        }
        ConeClassLikeType[] coneClassLikeTypeArray = new ConeClassLikeType[]{context2.getSession().getBuiltinTypes().getNothingType().getConeType()};
        ConeClassLikeType lambdaType = TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getFunction(), coneClassLikeTypeArray, false, null, 6, null);
        if (!ConstraintSystemBuilderKt.isSubtypeConstraintCompatible(csBuilder, lambdaType, $this$checkForContradiction.getExpectedType())) {
            sink.reportDiagnostic(new ArgumentTypeMismatch($this$checkForContradiction.getExpectedType(), lambdaType, $this$checkForContradiction.getExpression(), false, null, 16, null));
        }
    }

    private final boolean hasFunctionTypeConstraint(ConeLambdaWithTypeVariableAsExpectedTypeAtom $this$hasFunctionTypeConstraint, NewConstraintSystemImpl csBuilder, ResolutionContext context2) {
        boolean bl2;
        block4: {
            TypeConstructorMarker typeConstructor2 = TypeSystemContextHelpersKt.typeConstructor($this$hasFunctionTypeConstraint.getExpectedType(), context2.getTypeContext());
            VariableWithConstraints variableWithConstraints = csBuilder.currentStorage().getNotFixedTypeVariables().get(typeConstructor2);
            if (variableWithConstraints == null) {
                return false;
            }
            VariableWithConstraints variableWithConstraints2 = variableWithConstraints;
            Iterable $this$any$iv = variableWithConstraints2.getConstraints();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Constraint it = (Constraint)element$iv;
                    boolean bl3 = false;
                    KotlinTypeMarker kotlinTypeMarker = it.getType();
                    Intrinsics.checkNotNull((Object)kotlinTypeMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                    if (!FunctionalTypeUtilsKt.isSomeFunctionType((ConeKotlinType)kotlinTypeMarker, context2.getSession())) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
        }
        return bl2;
    }
}

