/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;

@PhaseDescription(name="JvmOverloadsAnnotation")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u000e*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering;", "Lksp/org/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "generateWrappers", "target", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "generateWrapper", "numDefaultParametersToExpect", "", "generateWrapperHeader", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFactory;", "oldFunction", "generateNewParameters", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmOverloadsAnnotationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n808#2,11:156\n774#2:167\n865#2,2:168\n1869#2,2:170\n1788#2,4:172\n1634#2,3:178\n1617#2,9:190\n1869#2:199\n1870#2:201\n1626#2:202\n404#3,2:176\n406#3:181\n315#4,4:182\n269#4,4:186\n1#5:200\n*S KotlinDebug\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n*L\n38#1:156,11\n38#1:167\n38#1:168,2\n42#1:170,2\n48#1:172,4\n72#1:178,3\n138#1:190,9\n138#1:199\n138#1:201\n138#1:202\n72#1:176,2\n72#1:181\n103#1:182,4\n112#1:186,4\n138#1:200\n*E\n"})
public final class JvmOverloadsAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmOverloadsAnnotationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrClass irClass) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrFunction it = (IrFunction)element$iv$iv;
            boolean bl2 = false;
            if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)it, JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_FQ_NAME())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List functions = (List)destination$iv$iv;
        Iterable $this$forEach$iv = functions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFunction it = (IrFunction)element$iv;
            boolean bl3 = false;
            this.generateWrappers(it, irClass);
        }
    }

    private final void generateWrappers(IrFunction target, IrClass irClass) {
        int n2;
        Iterable $this$count$iv = target.getParameters();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                if (!(it.getDefaultValue() != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int numDefaultParameters = n2;
        for (int i2 = numDefaultParameters - 1; -1 < i2; --i2) {
            IrFunction wrapper = this.generateWrapper(target, i2);
            IrDeclarationsKt.addMember(irClass, wrapper);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction generateWrapper(IrFunction target, int numDefaultParametersToExpect) {
        IrBody irBody;
        void $this$assignFrom$iv;
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunction wrapperIrFunction = this.generateWrapperHeader(this.context.getIrFactory(), target, numDefaultParametersToExpect);
        IrFunction irFunction = target;
        if (irFunction instanceof IrConstructor) {
            irFunctionAccessExpression = BuildersKt.fromSymbolOwner$default(IrDelegatingConstructorCallImpl.Companion, -1, -1, this.context.getIrBuiltIns().getUnitType(), ((IrConstructor)target).getSymbol(), 0, 16, null);
        } else if (irFunction instanceof IrSimpleFunction) {
            irFunctionAccessExpression = BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, -1, -1, target.getReturnType(), ((IrSimpleFunction)target).getSymbol(), null, null, 48, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunctionAccessExpression call2 = irFunctionAccessExpression;
        for (IrTypeParameter arg : IrUtilsKt.getAllTypeParameters(wrapperIrFunction)) {
            call2.getTypeArguments().set(arg.getIndex(), IrTypesKt.getDefaultType(arg));
        }
        Ref.IntRef parametersCopied = new Ref.IntRef();
        int defaultParametersCopied = 0;
        Object object = call2.getArguments();
        Iterable other$iv = target.getParameters();
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        Iterable $this$mapTo$iv$iv = other$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrGetValueImpl irGetValueImpl;
            void valueParameter2;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = (Collection)$this$assignFrom$iv;
            boolean bl2 = false;
            if (valueParameter2.getDefaultValue() == null) {
                irGetValueImpl = JvmOverloadsAnnotationLowering.generateWrapper$lambda$3$irGetParameter(wrapperIrFunction, parametersCopied);
            } else if (defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                irGetValueImpl = JvmOverloadsAnnotationLowering.generateWrapper$lambda$3$irGetParameter(wrapperIrFunction, parametersCopied);
            } else {
                irGetValueImpl = null;
            }
            collection.add((IrExpression)irGetValueImpl);
        }
        Collection cfr_ignored_0 = (Collection)$this$assignFrom$iv;
        object = target;
        if (object instanceof IrConstructor) {
            irBody = IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, CollectionsKt.listOf((Object)call2));
        } else if (object instanceof IrSimpleFunction) {
            irBody = this.context.getIrFactory().createExpressionBody(-1, -1, call2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        wrapperIrFunction.setBody(irBody);
        return wrapperIrFunction;
    }

    private final IrFunction generateWrapperHeader(IrFactory $this$generateWrapperHeader, IrFunction oldFunction, int numDefaultParametersToExpect) {
        IrFunction irFunction;
        IrFunction irFunction2 = oldFunction;
        if (irFunction2 instanceof IrConstructor) {
            IrFactory $this$buildConstructor$iv = $this$generateWrapperHeader;
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2427$iv = new IrFunctionBuilder();
            boolean bl2 = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u244 = $this$buildConstructor_u24lambda_u2427$iv;
            boolean bl3 = false;
            IrElementBuilderKt.setSourceRange($this$generateWrapperHeader_u24lambda_u244, oldFunction);
            $this$generateWrapperHeader_u24lambda_u244.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getJVM_OVERLOADS_WRAPPER());
            $this$generateWrapperHeader_u24lambda_u244.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u244.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u244.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u244.setInline(oldFunction.isInline());
            irFunction = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2427$iv);
        } else if (irFunction2 instanceof IrSimpleFunction) {
            IrFactory $this$buildFun$iv = $this$generateWrapperHeader;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2423$iv = new IrFunctionBuilder();
            boolean bl4 = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u245 = $this$buildFun_u24lambda_u2423$iv;
            boolean bl5 = false;
            IrElementBuilderKt.setSourceRange($this$generateWrapperHeader_u24lambda_u245, oldFunction);
            $this$generateWrapperHeader_u24lambda_u245.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getJVM_OVERLOADS_WRAPPER());
            $this$generateWrapperHeader_u24lambda_u245.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u245.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u245.setModality(this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.GenerateJvmOverloadsAsFinal) ? Modality.FINAL : ((IrSimpleFunction)oldFunction).getModality());
            $this$generateWrapperHeader_u24lambda_u245.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u245.setInline(oldFunction.isInline());
            $this$generateWrapperHeader_u24lambda_u245.setSuspend(((IrSimpleFunction)oldFunction).isSuspend());
            irFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2423$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunction res2 = irFunction;
        res2.setParent(oldFunction.getParent());
        IrUtilsKt.copyAnnotationsFrom(res2, oldFunction);
        IrUtilsKt.copyTypeParametersFrom$default(res2, oldFunction, null, null, 6, null);
        res2.setParameters(CollectionsKt.plus((Collection)res2.getParameters(), (Iterable)this.generateNewParameters(res2, oldFunction, numDefaultParametersToExpect)));
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrValueParameter> generateNewParameters(IrFunction $this$generateNewParameters, IrFunction oldFunction, int numDefaultParametersToExpect) {
        void $this$mapNotNullTo$iv$iv;
        int defaultParametersCopied = 0;
        Iterable $this$mapNotNull$iv = oldFunction.getParameters();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrValueParameter irValueParameter;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            IrValueParameter oldParameter = (IrValueParameter)element$iv$iv;
            boolean bl3 = false;
            if (oldParameter.getDefaultValue() == null) {
                irValueParameter = IrUtilsKt.copyTo$default(oldParameter, $this$generateNewParameters, null, 0, 0, null, null, null, null, null, false, false, false, null, 8190, null);
            } else if (defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                irValueParameter = IrUtilsKt.copyTo$default(oldParameter, $this$generateNewParameters, null, 0, 0, null, null, null, null, null, oldParameter.isCrossinline(), oldParameter.isNoinline(), false, null, 6398, null);
            } else {
                irValueParameter = null;
            }
            if (irValueParameter == null) continue;
            IrValueParameter it$iv$iv = irValueParameter;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final IrGetValueImpl generateWrapper$lambda$3$irGetParameter(IrFunction wrapperIrFunction, Ref.IntRef parametersCopied) {
        int n2 = parametersCopied.element;
        parametersCopied.element = n2 + 1;
        return BuildersKt.IrGetValueImpl$default(-1, -1, wrapperIrFunction.getParameters().get(n2).getSymbol(), null, 8, null);
    }
}

