/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.config.ReturnValueCheckerMode;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtAnnotated;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/ReturnValueAnnotationChecker;", "Lksp/org/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "<init>", "()V", "mustUseReturnValueFq", "Lksp/org/jetbrains/kotlin/name/FqName;", "getMustUseReturnValueFq", "()Lorg/jetbrains/kotlin/name/FqName;", "ignorableFq", "getIgnorableFq", "checkEntries", "", "entries", "", "Lksp/org/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lksp/org/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lksp/org/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class ReturnValueAnnotationChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final ReturnValueAnnotationChecker INSTANCE = new ReturnValueAnnotationChecker();
    @NotNull
    private static final FqName mustUseReturnValueFq = new FqName("kotlin.MustUseReturnValue");
    @NotNull
    private static final FqName ignorableFq = new FqName("kotlin.IgnorableReturnValue");

    private ReturnValueAnnotationChecker() {
    }

    @NotNull
    public final FqName getMustUseReturnValueFq() {
        return mustUseReturnValueFq;
    }

    @NotNull
    public final FqName getIgnorableFq() {
        return ignorableFq;
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (languageVersionSettings.getFlag(AnalysisFlags.getReturnValueCheckerMode()) != ReturnValueCheckerMode.DISABLED) {
            return;
        }
        for (KtAnnotationEntry ktAnnotationEntry : entries) {
            FqName name2;
            AnnotationDescriptor descriptor2;
            if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, ktAnnotationEntry) == null || descriptor2.getFqName() == null || !Intrinsics.areEqual((Object)name2, (Object)mustUseReturnValueFq) && !Intrinsics.areEqual((Object)name2, (Object)ignorableFq)) continue;
            trace.report(Errors.IGNORABILITY_ANNOTATIONS_WITH_CHECKER_DISABLED.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry)));
        }
    }
}

