/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.search;

import ksp.com.intellij.core.CoreBundle;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.NotNullLazyKey;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.search.ProjectScopeBuilder;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NotNull;

public final class ProjectScope {
    private static final NotNullLazyKey<GlobalSearchScope, Project> ALL_SCOPE_KEY = NotNullLazyKey.createLazyKey("ALL_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildAllScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> PROJECT_SCOPE_KEY = NotNullLazyKey.createLazyKey("PROJECT_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildProjectScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> LIBRARIES_SCOPE_KEY = NotNullLazyKey.createLazyKey("LIBRARIES_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildLibrariesScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> CONTENT_SCOPE_KEY = NotNullLazyKey.createLazyKey("CONTENT_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildContentScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> EVERYTHING_SCOPE_KEY = NotNullLazyKey.createLazyKey("EVERYTHING_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildEverythingScope());

    private ProjectScope() {
    }

    @NotNull
    public static GlobalSearchScope getAllScope(@NotNull Project project) {
        if (project == null) {
            ProjectScope.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = ALL_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            ProjectScope.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getProjectScope(@NotNull Project project) {
        if (project == null) {
            ProjectScope.$$$reportNull$$$0(2);
        }
        GlobalSearchScope globalSearchScope = PROJECT_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            ProjectScope.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getLibrariesScope(@NotNull Project project) {
        if (project == null) {
            ProjectScope.$$$reportNull$$$0(4);
        }
        GlobalSearchScope globalSearchScope = LIBRARIES_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            ProjectScope.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getContentScope(@NotNull Project project) {
        if (project == null) {
            ProjectScope.$$$reportNull$$$0(6);
        }
        GlobalSearchScope globalSearchScope = CONTENT_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            ProjectScope.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getEverythingScope(@NotNull Project project) {
        if (project == null) {
            ProjectScope.$$$reportNull$$$0(8);
        }
        GlobalSearchScope globalSearchScope = EVERYTHING_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            ProjectScope.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    @Nls
    public static String getProjectFilesScopeName() {
        String string = CoreBundle.message("psi.search.scope.project", new Object[0]);
        if (string == null) {
            ProjectScope.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/search/ProjectScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/search/ProjectScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEverythingScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFilesScopeName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllScope";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibrariesScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContentScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEverythingScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

