/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.types.expressions

import ksp.com.intellij.psi.impl.source.tree.LeafPsiElement
import ksp.com.intellij.psi.util.PsiTreeUtil
import ksp.org.jetbrains.kotlin.diagnostics.Errors
import ksp.org.jetbrains.kotlin.lexer.KtTokens
import ksp.org.jetbrains.kotlin.psi.KtOperationExpression
import ksp.org.jetbrains.kotlin.psi.KtPostfixExpression
import ksp.org.jetbrains.kotlin.psi.KtTypeReference
import ksp.org.jetbrains.kotlin.psi.KtUserType
import ksp.org.jetbrains.kotlin.psi.psiUtil.nextLeaf

fun KtOperationExpression.reportDeprecatedDefinitelyNotNullSyntax(
    rhs: KtTypeReference?,
    context: ExpressionTypingContext
) {
    val nextLeaf = nextLeaf()
    if (nextLeaf is LeafPsiElement && nextLeaf.elementType === KtTokens.EXCLEXCL && rhs?.typeElement is KtUserType) {
        val parent = PsiTreeUtil.findCommonParent(nextLeaf, this)
        if (parent is KtPostfixExpression && parent.operationToken === KtTokens.EXCLEXCL) {
            context.trace.report(Errors.DEPRECATED_SYNTAX_WITH_DEFINITELY_NOT_NULL.on((parent as KtPostfixExpression?)!!))
        }
    }
}
