/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi2ir.generators

import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor
import ksp.org.jetbrains.kotlin.descriptors.SourceElement
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor
import ksp.org.jetbrains.kotlin.ir.UNDEFINED_OFFSET
import ksp.org.jetbrains.kotlin.ir.util.ConstantValueGenerator
import ksp.org.jetbrains.kotlin.ir.util.ReferenceSymbolTable
import ksp.org.jetbrains.kotlin.ir.util.TypeTranslator
import ksp.org.jetbrains.kotlin.name.Name
import ksp.org.jetbrains.kotlin.psi.psiUtil.endOffset
import ksp.org.jetbrains.kotlin.psi.psiUtil.startOffset
import ksp.org.jetbrains.kotlin.resolve.lazy.descriptors.getSourceForArgument
import ksp.org.jetbrains.kotlin.resolve.source.getPsi

internal class ConstantValueGeneratorImpl(
    moduleDescriptor: ModuleDescriptor,
    symbolTable: ReferenceSymbolTable,
    typeTranslator: TypeTranslator,
    allowErrorTypeInAnnotations: Boolean,
) : ConstantValueGenerator(moduleDescriptor, symbolTable, typeTranslator, allowErrorTypeInAnnotations) {
    override fun extractAnnotationOffsets(annotationDescriptor: AnnotationDescriptor): Pair<Int, Int> =
        extractOffsets(annotationDescriptor.source)

    override fun extractAnnotationParameterOffsets(annotationDescriptor: AnnotationDescriptor, argumentName: Name): Pair<Int, Int> =
        extractOffsets(annotationDescriptor.getSourceForArgument(argumentName))

    private fun extractOffsets(sourceElement: SourceElement): Pair<Int, Int> {
        val psi = sourceElement.getPsi()
        if (psi == null || psi.containingFile.fileType.isBinary) return UNDEFINED_OFFSET to UNDEFINED_OFFSET
        return Pair(psi.startOffset, psi.endOffset)
    }
}
