/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.parsing;

import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.util.diff.FlyweightCapableTreeStructure;

public class KotlinLightParser {
    public static FlyweightCapableTreeStructure<LighterASTNode> parse(PsiBuilder builder) {
        KotlinParsing ktParsing = KotlinParsing.createForTopLevelNonLazy(new SemanticWhitespaceAwarePsiBuilderImpl(builder));
        ktParsing.parseFile();

        return builder.getLightTree();
    }
}
