/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.declarations

import ksp.org.jetbrains.kotlin.ir.IrElementBase
import ksp.org.jetbrains.kotlin.ir.util.render

/**
 * Unlike other [IrElement]s, this class is only an implementation detail, introduced
 * for convenience and performance.
 * As such, it is not autogenerated, but needs to be kept in sync with the entry in
 * tree generator: [org.jetbrains.kotlin.ir.generator.IrTree.declarationBase]
 */
abstract class IrDeclarationBase : IrElementBase(), IrDeclaration {
    internal var _parent: IrDeclarationParent? = null
        private set
    final override var parent: IrDeclarationParent
        get() = _parent ?: error(
            "Parent of element (${this.render()}) is not initialized.\n" +
                    "Please assign it explicitly or use utility such as IrElement.patchDeclarationParents()."
        )
        set(value) {
            _parent = value
        }
}
