/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ksp.org.jetbrains.kotlin.incremental

import ksp.org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache
import ksp.org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents
import ksp.org.jetbrains.kotlin.modules.TargetId

class IncrementalCompilationComponentsImpl(
        private val caches: Map<TargetId, IncrementalCache>
): IncrementalCompilationComponents {
    override fun getIncrementalCache(target: TargetId): IncrementalCache =
            caches[target] ?: throw Exception("Incremental cache for target ${target.name} not found")
}
