/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers

import ksp.org.jetbrains.kotlin.descriptors.Visibilities
import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction
import ksp.org.jetbrains.kotlin.fir.declarations.hasAnnotation
import ksp.org.jetbrains.kotlin.fir.declarations.utils.visibility
import ksp.org.jetbrains.kotlin.fir.resolve.providers.firProvider
import ksp.org.jetbrains.kotlin.name.WebCommonStandardClassIds

fun isJsExportedDeclaration(declaration: FirDeclaration, session: FirSession): Boolean {
    if (declaration !is FirSimpleFunction)
        return false

    if (declaration.visibility != Visibilities.Public)
        return false

    if (declaration.hasAnnotation(WebCommonStandardClassIds.Annotations.JsExport, session))
        return true

    val containerFile = session.firProvider.getFirCallableContainerFile(declaration.symbol)
    return containerFile != null && containerFile.hasAnnotation(WebCommonStandardClassIds.Annotations.JsExport, session)
}