/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.expression

import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.builtins.StandardNames
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.diagnostics.reportOn
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.AbstractFirReflectionApiCallChecker
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors
import ksp.org.jetbrains.kotlin.name.ClassId
import ksp.org.jetbrains.kotlin.name.Name
import ksp.org.jetbrains.kotlin.name.StandardClassIds

object FirJsReflectionAPICallChecker : AbstractFirReflectionApiCallChecker() {
    override fun isWholeReflectionApiAvailable(context: CheckerContext): Boolean {
        return false
    }

    override fun isAllowedReflectionApi(name: Name, containingClassId: ClassId, context: CheckerContext): Boolean {
        return super.isAllowedReflectionApi(name, containingClassId, context) ||
                containingClassId in StandardClassIds.Annotations.associatedObjectAnnotations ||
                name == StandardNames.FqNames.findAssociatedObject.shortName()
    }

    override fun report(source: KtSourceElement?, context: CheckerContext, reporter: DiagnosticReporter) {
        reporter.reportOn(source, FirErrors.UNSUPPORTED, "This reflection API is not supported in Kotlin JS.", context)
    }
}
