/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration

import ksp.org.jetbrains.kotlin.descriptors.ClassKind
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.diagnostics.reportOn
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.getAllowedAnnotationTargets
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.getTargetAnnotation
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass
import ksp.org.jetbrains.kotlin.fir.declarations.getAnnotationByClassId
import ksp.org.jetbrains.kotlin.fir.declarations.getRetention
import ksp.org.jetbrains.kotlin.fir.declarations.getRetentionAnnotation
import ksp.org.jetbrains.kotlin.resolve.checkers.OptInDescription
import ksp.org.jetbrains.kotlin.resolve.checkers.OptInNames

object FirOptInAnnotationClassChecker : FirRegularClassChecker(MppCheckerKind.Common) {
    context(context: CheckerContext, reporter: DiagnosticReporter)
    override fun check(declaration: FirRegularClass) {
        if (declaration.classKind != ClassKind.ANNOTATION_CLASS) return
        val session = context.session
        if (declaration.getAnnotationByClassId(OptInNames.REQUIRES_OPT_IN_CLASS_ID, session) == null) return
        if (declaration.getRetention(session) == AnnotationRetention.SOURCE) {
            val target = declaration.getRetentionAnnotation(session)
            reporter.reportOn(target?.source, FirErrors.OPT_IN_MARKER_WITH_WRONG_RETENTION)

        }
        val wrongTargets = declaration.getAllowedAnnotationTargets(session).intersect(OptInDescription.WRONG_TARGETS_FOR_MARKER)
        if (wrongTargets.isNotEmpty()) {
            val target = declaration.getTargetAnnotation(session)
            reporter.reportOn(
                target?.source,
                FirErrors.OPT_IN_MARKER_WITH_WRONG_TARGET,
                wrongTargets.joinToString(transform = KotlinTarget::description)
            )
        }
    }
}
