/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.checkers

import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.FirSessionComponent
import ksp.org.jetbrains.kotlin.name.ClassId
import ksp.org.jetbrains.kotlin.name.StandardClassIds

abstract class FirPrimaryConstructorSuperTypeCheckerPlatformComponent : FirSessionComponent {
    abstract val supertypesThatDontNeedInitializationInSubtypesConstructors: Set<ClassId>

    object Default : FirPrimaryConstructorSuperTypeCheckerPlatformComponent() {
        override val supertypesThatDontNeedInitializationInSubtypesConstructors: Set<ClassId> = setOf(StandardClassIds.Enum)
    }
}

val FirSession.primaryConstructorSuperTypePlatformSupport: FirPrimaryConstructorSuperTypeCheckerPlatformComponent by FirSession.sessionComponentAccessor<FirPrimaryConstructorSuperTypeCheckerPlatformComponent>()
