/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.config

import ksp.org.jetbrains.kotlin.library.KotlinAbiVersion

enum class KlibAbiCompatibilityLevel(val major: Int, val minor: Int) {
    ABI_LEVEL_2_1(2, 1) {
        override fun toAbiVersionForManifest(): KotlinAbiVersion = KotlinAbiVersion(1, 201, 0)
    },
    ABI_LEVEL_2_2(2, 2),
    ;

    override fun toString() = "$major.$minor"

    open fun toAbiVersionForManifest(): KotlinAbiVersion = KotlinAbiVersion(major, minor, 0)

    fun isAtLeast(other: KlibAbiCompatibilityLevel): Boolean =
        major > other.major || major == other.major && minor >= other.minor

    companion object {
        val LATEST_STABLE = ABI_LEVEL_2_2
    }
}
