/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.cli.common.extensions

import ksp.com.intellij.core.JavaCoreProjectEnvironment
import ksp.org.jetbrains.kotlin.cli.common.ExitCode
import ksp.org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments
import ksp.org.jetbrains.kotlin.config.CompilerConfiguration
import ksp.org.jetbrains.kotlin.extensions.ProjectExtensionDescriptor

interface ShellExtension {
    companion object : ProjectExtensionDescriptor<ShellExtension>(
        "org.jetbrains.kotlin.shellExtension",
        ShellExtension::class.java
    )

    fun isAccepted(arguments: CommonCompilerArguments): Boolean

    fun run(
        arguments: CommonCompilerArguments,
        configuration: CompilerConfiguration,
        projectEnvironment: JavaCoreProjectEnvironment
    ): ExitCode
}
