/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ksp.org.jetbrains.kotlin.backend.jvm.intrinsics

import ksp.org.jetbrains.kotlin.backend.jvm.codegen.*
import ksp.org.jetbrains.kotlin.codegen.AsmUtil
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression
import ksp.org.jetbrains.kotlin.ir.util.getArrayElementType
import ksp.org.jetbrains.org.objectweb.asm.Type

object ArraySet : IntrinsicMethod() {
    override fun invoke(expression: IrFunctionAccessExpression, codegen: ExpressionCodegen, data: BlockInfo): PromisedValue {
        val (dispatchReceiver, indexExpression, valueExpression) = expression.arguments
        val receiver = dispatchReceiver!!.accept(codegen, data).materializedAt(dispatchReceiver.type)
        val elementType = AsmUtil.correctElementType(receiver.type)
        val elementIrType = receiver.irType.getArrayElementType(codegen.context.irBuiltIns)
        indexExpression!!.accept(codegen, data).materializeAt(Type.INT_TYPE, codegen.context.irBuiltIns.intType)
        valueExpression!!.accept(codegen, data).materializeAt(elementType, elementIrType)
        codegen.mv.astore(elementType)
        return codegen.unitValue
    }
}
