/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.jvm

import ksp.org.jetbrains.kotlin.backend.jvm.ir.IrJvmFlexibleType
import ksp.org.jetbrains.kotlin.backend.jvm.ir.asJvmFlexibleType
import ksp.org.jetbrains.kotlin.backend.jvm.ir.isWithFlexibleMutability
import ksp.org.jetbrains.kotlin.backend.jvm.ir.isWithFlexibleNullability
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType
import ksp.org.jetbrains.kotlin.ir.types.IrType
import ksp.org.jetbrains.kotlin.ir.types.IrTypeSystemContext
import ksp.org.jetbrains.kotlin.types.model.FlexibleTypeMarker
import ksp.org.jetbrains.kotlin.types.model.KotlinTypeMarker
import ksp.org.jetbrains.kotlin.ir.types.isMarkedNullable as irIsMarkedNullable

class JvmIrTypeSystemContext(override val irBuiltIns: IrBuiltIns) : IrTypeSystemContext {
    override fun KotlinTypeMarker.asFlexibleType(): FlexibleTypeMarker? =
        (this as IrType).asJvmFlexibleType(irBuiltIns, JvmIrSpecialAnnotationSymbolProvider)

    override fun FlexibleTypeMarker.upperBound(): IrSimpleType {
        return when (this) {
            is IrJvmFlexibleType -> this.upperBound
            else -> error("Unexpected flexible type ${this::class.java.simpleName}: $this")
        }
    }

    override fun FlexibleTypeMarker.lowerBound(): IrSimpleType {
        return when (this) {
            is IrJvmFlexibleType -> this.lowerBound
            else -> error("Unexpected flexible type ${this::class.java.simpleName}: $this")
        }
    }

    override fun KotlinTypeMarker.isMarkedNullable(): Boolean =
        this is IrSimpleType && !isWithFlexibleNullability() && irIsMarkedNullable()

    override fun KotlinTypeMarker.isDynamic(): Boolean =
        false

    override fun KotlinTypeMarker.isFlexibleWithDifferentTypeConstructors(): Boolean =
        (this as IrType).isWithFlexibleMutability()
}
