/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.asJava.elements

import ksp.com.intellij.psi.PsiAnnotationMemberValue
import ksp.com.intellij.psi.PsiElement
import ksp.com.intellij.psi.PsiIdentifier
import ksp.com.intellij.psi.PsiLiteralExpression
import ksp.com.intellij.psi.PsiNameValuePair
import ksp.com.intellij.psi.impl.light.LightIdentifier
import ksp.org.jetbrains.kotlin.asJava.classes.cannotModify
import ksp.org.jetbrains.kotlin.asJava.classes.lazyPub
import ksp.org.jetbrains.kotlin.psi.KtElement
import kotlin.getValue

class KtLightPsiNameValuePair(
    override val kotlinOrigin: KtElement,
    private val name: String,
    lightParent: PsiElement,
    private val argument: (KtLightPsiNameValuePair) -> PsiAnnotationMemberValue?
) : KtLightElementBase(lightParent),
    PsiNameValuePair {

    override fun setValue(newValue: PsiAnnotationMemberValue): PsiAnnotationMemberValue = cannotModify()

    override fun getNameIdentifier(): PsiIdentifier? = LightIdentifier(kotlinOrigin.manager, name)

    override fun getName(): String? = name

    private val _value: PsiAnnotationMemberValue? by lazyPub { argument(this) }

    override fun getValue(): PsiAnnotationMemberValue? = _value

    override fun getLiteralValue(): String? = (value as? PsiLiteralExpression)?.value?.toString()

}