/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.project.structure.builder

import ksp.com.intellij.openapi.project.Project
import ksp.org.jetbrains.kotlin.analysis.api.KaExperimentalApi
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule
import ksp.org.jetbrains.kotlin.analysis.project.structure.impl.KaScriptModuleImpl
import ksp.org.jetbrains.kotlin.config.ApiVersion
import ksp.org.jetbrains.kotlin.config.LanguageVersion
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettingsImpl
import ksp.org.jetbrains.kotlin.psi.KtFile
import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract

@KaExperimentalApi
@KtModuleBuilderDsl
public class KtScriptModuleBuilder(private val project: Project) : KtModuleBuilder() {
    public lateinit var file: KtFile

    public var languageVersionSettings: LanguageVersionSettings =
        LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST)

    override fun build(): KaScriptModule {
        return KaScriptModuleImpl(
            directRegularDependencies,
            directDependsOnDependencies,
            directFriendDependencies,
            platform,
            project,
            file,
            languageVersionSettings
        )
    }
}

@KaExperimentalApi
@OptIn(ExperimentalContracts::class)
public inline fun KtModuleProviderBuilder.buildKtScriptModule(init: KtScriptModuleBuilder.() -> Unit): KaScriptModule {
    contract {
        callsInPlace(init, InvocationKind.EXACTLY_ONCE)
    }
    return KtScriptModuleBuilder(project).apply(init).build()
}
