/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.stubBased.deserialization

import ksp.org.jetbrains.kotlin.descriptors.SourceFile
import ksp.org.jetbrains.kotlin.load.kotlin.FacadeClassSource
import ksp.org.jetbrains.kotlin.resolve.jvm.JvmClassName
import ksp.org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.PreReleaseInfo

internal class JvmStubDeserializedFacadeContainerSource(
    override val className: JvmClassName,
    override val facadeClassName: JvmClassName?
) : DeserializedContainerSourceWithJvmClassName, FacadeClassSource {
    override val incompatibility: IncompatibleVersionErrorData<*>?
        get() = null

    override val preReleaseInfo: PreReleaseInfo
        get() = PreReleaseInfo.DEFAULT_VISIBLE

    override val abiStability: DeserializedContainerAbiStability
        get() = DeserializedContainerAbiStability.STABLE

    override val presentableString: String
        get() = className.internalName

    override fun getContainingFile(): SourceFile = SourceFile.NO_SOURCE_FILE
}