/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.decompiled.light.classes

import ksp.com.intellij.psi.PsiClass
import ksp.com.intellij.psi.PsiElement
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile
import ksp.org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade
import ksp.org.jetbrains.kotlin.fileClasses.javaFileFacadeFqName
import ksp.org.jetbrains.kotlin.load.java.structure.LightClassOriginKind
import ksp.org.jetbrains.kotlin.name.FqName
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject
import ksp.org.jetbrains.kotlin.psi.KtFile

internal class KtLightClassForDecompiledFacade(
    clsDelegate: PsiClass,
    clsParent: PsiElement,
    file: KtClsFile,
    kotlinOrigin: KtClassOrObject?,
    override val files: Collection<KtFile>,
) : KtLightClassForDecompiledDeclaration(clsDelegate, clsParent, file, kotlinOrigin), KtLightClassForFacade {
    override fun getName(): String = super<KtLightClassForFacade>.getName()
    override val facadeClassFqName: FqName get() = file.javaFileFacadeFqName
    override val originKind: LightClassOriginKind get() = LightClassOriginKind.BINARY

    override val multiFileClass: Boolean = false
}