/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.impl.base.components

import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.KaSession
import ksp.org.jetbrains.kotlin.analysis.api.components.KaSubtypingErrorTypePolicy
import ksp.org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.assertIsValidAndAccessible
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol
import ksp.org.jetbrains.kotlin.analysis.api.types.KaErrorType
import ksp.org.jetbrains.kotlin.analysis.api.types.KaType
import ksp.org.jetbrains.kotlin.name.ClassId

@KaImplementationDetail
abstract class KaBaseTypeRelationChecker<T : KaSession> : KaBaseSessionComponent<T>(), KaTypeRelationChecker {
    override fun KaType.isSubtypeOf(classId: ClassId, errorTypePolicy: KaSubtypingErrorTypePolicy): Boolean {
        if (this is KaErrorType) return errorTypePolicy == KaSubtypingErrorTypePolicy.LENIENT

        return isClassSubtypeOf(classId, errorTypePolicy)
    }

    protected abstract fun KaType.isClassSubtypeOf(classId: ClassId, errorTypePolicy: KaSubtypingErrorTypePolicy): Boolean

    override fun KaType.isSubtypeOf(symbol: KaClassLikeSymbol, errorTypePolicy: KaSubtypingErrorTypePolicy): Boolean {
        symbol.assertIsValidAndAccessible()

        if (this is KaErrorType) return errorTypePolicy == KaSubtypingErrorTypePolicy.LENIENT

        return isClassSubtypeOf(symbol, errorTypePolicy)
    }

    protected abstract fun KaType.isClassSubtypeOf(
        symbol: KaClassLikeSymbol,
        errorTypePolicy: KaSubtypingErrorTypePolicy,
    ): Boolean
}
