// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.util.indexing.flavor;

import ksp.com.intellij.openapi.fileTypes.FileTypeExtension;
import ksp.com.intellij.util.indexing.IndexedFile;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

/**
 * Provider that allows to customize indexing hash evaluation {@link com.intellij.util.indexing.IndexedHashesSupport} via mixing additional objects to hash function.
 */
@ApiStatus.Internal
@ApiStatus.Experimental
public interface FileIndexingFlavorProvider<Flavor> {
  FileTypeExtension<FileIndexingFlavorProvider<?>> INSTANCE = new FileTypeExtension<>("com.intellij.indexingFlavor");

  @Nullable
  Flavor getFlavor(@NotNull IndexedFile file);

  void buildHash(@NotNull Flavor flavor, @NotNull HashBuilder hashBuilder);

  int getVersion();

  @NotNull
  String getId();
}
