// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.ui;

import ksp.com.intellij.ide.FileIconPatcher;
import ksp.com.intellij.ide.FileIconProvider;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Iconable;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import javax.swing.*;

public interface CoreAwareIconManager {
  /**
   * @return a deferred icon for the file, taking into account {@link FileIconProvider} and {@link FileIconPatcher} extensions.
   * Use {@link com.intellij.util.IconUtil#computeFileIcon} where possible (e.g. in background threads) to get a non-deferred icon.
   */
  @NotNull Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project);

  @NotNull Runnable wakeUpNeo(@NotNull Object reason);
}
