// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

/*
 * @author max
 */
package ksp.com.intellij.psi.impl.source.tree;

import ksp.com.intellij.lang.ASTFactory;
import ksp.com.intellij.psi.PlainTextTokenTypes;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PlainTextASTFactory extends ASTFactory {

  @Override
  public @Nullable LeafElement createLeaf(@NotNull IElementType type, @NotNull CharSequence text) {
    if (type == PlainTextTokenTypes.PLAIN_TEXT) {
      return new PsiPlainTextImpl(text);
    }
    return null;
  }
}
