// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package ksp.com.intellij.psi.impl.source.resolve.reference;

import ksp.com.intellij.patterns.ElementPattern;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiReferenceProvider;
import ksp.com.intellij.psi.PsiReferenceService;
import ksp.com.intellij.util.ProcessingContext;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;

import java.util.List;

class SimpleProviderBinding implements ProviderBinding {
  private final List<ProviderInfo<ElementPattern<?>>> myProviderPairs = ContainerUtil.createLockFreeCopyOnWriteList();

  void registerProvider(@NotNull PsiReferenceProvider provider, @NotNull ElementPattern<?> pattern, double priority) {
    myProviderPairs.add(new ProviderInfo<>(provider, pattern, priority));
  }

  @Override
  public void addAcceptableReferenceProviders(@NotNull PsiElement position,
                                              @NotNull List<? super ProviderInfo<ProcessingContext>> list,
                                              @NotNull PsiReferenceService.Hints hints) {
    NamedObjectProviderBinding.addMatchingProviders(position, myProviderPairs, list, hints);
  }

  @Override
  public void unregisterProvider(@NotNull PsiReferenceProvider provider) {
    myProviderPairs.removeIf(trinity -> trinity.provider.equals(provider));
  }

  boolean isEmpty() {
    return myProviderPairs.isEmpty();
  }
}
