// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.source.codeStyle;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

public abstract class IndentHelper {
  public static IndentHelper getInstance() {
    return ApplicationManager.getApplication().getService(IndentHelper.class);
  }

  /**
   * @deprecated Use {@link #getIndent(PsiFile, ASTNode, boolean)}
   */
  @Deprecated
  @ApiStatus.ScheduledForRemoval
  public final int getIndent(Project project, FileType fileType, ASTNode element, boolean includeNonSpace) {
    return getIndent(getFile(element), element, includeNonSpace);
  }

  private static PsiFile getFile(ASTNode element) {
    return element.getPsi().getContainingFile();
  }

  public abstract int getIndent(@NotNull PsiFile file, @NotNull ASTNode element);

  public abstract int getIndent(@NotNull PsiFile file, @NotNull ASTNode element, boolean includeNonSpace);
}
