/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * @author max
 */
package ksp.com.intellij.psi.impl.source;

import ksp.com.intellij.lang.Language;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.util.CharTable;
import ksp.org.jetbrains.annotations.NotNull;

public interface HolderFactory {
  @NotNull
  DummyHolder createHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context);
  @NotNull
  DummyHolder createHolder(@NotNull PsiManager manager, CharTable table, boolean validity);
  @NotNull
  DummyHolder createHolder(@NotNull PsiManager manager, PsiElement context);
  @NotNull
  DummyHolder createHolder(@NotNull PsiManager manager, Language language, PsiElement context);
  @NotNull
  DummyHolder createHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context, CharTable table);
  @NotNull
  DummyHolder createHolder(@NotNull PsiManager manager, PsiElement context, CharTable table);
  @NotNull
  DummyHolder createHolder(@NotNull PsiManager manager, CharTable table, Language language);
  
}