// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.java.stubs;

import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.PsiJavaFile;
import ksp.com.intellij.psi.PsiJavaModule;
import ksp.com.intellij.psi.stubs.PsiClassHolderFileStub;
import ksp.org.jetbrains.annotations.ApiStatus;

public interface PsiJavaFileStub extends PsiClassHolderFileStub<PsiJavaFile> {
  PsiJavaModule getModule();

  String getPackageName();
  LanguageLevel getLanguageLevel();
  boolean isCompiled();

  StubPsiFactory getPsiFactory();

  /** @deprecated override {@link #getPsiFactory()} instead */
  @Deprecated
  @ApiStatus.ScheduledForRemoval
  void setPsiFactory(StubPsiFactory factory);
}