// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.impl;

import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.util.messages.Topic;
import ksp.org.jetbrains.annotations.NotNull;

public interface PsiDocumentTransactionListener {

  @Topic.ProjectLevel
  @Topic.AppLevel
  Topic<PsiDocumentTransactionListener> TOPIC =
    new Topic<>("psi.DocumentTransactionListener", PsiDocumentTransactionListener.class, Topic.BroadcastDirection.TO_PARENT);

  void transactionStarted(@NotNull Document document, @NotNull PsiFile file);

  default void transactionCompleted(@NotNull Document document, @NotNull PsiFile file) {
  }
}
