// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

/*
 * @author max
 */
package ksp.com.intellij.psi;

import ksp.com.intellij.openapi.project.Project;
import ksp.org.jetbrains.annotations.NotNull;

public abstract class SmartTypePointerManager {
  public static SmartTypePointerManager getInstance(Project project) {
    return project.getService(SmartTypePointerManager.class);
  }

  @NotNull
  public abstract SmartTypePointer createSmartTypePointer(@NotNull PsiType type);
}