// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.pom.wrappers;

import ksp.com.intellij.pom.PomModelAspect;
import ksp.com.intellij.pom.core.impl.PomModelImpl;
import ksp.com.intellij.pom.event.PomModelEvent;
import ksp.com.intellij.pom.tree.TreeAspect;
import ksp.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import ksp.com.intellij.psi.PsiDocumentManager;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.impl.PsiDocumentManagerBase;
import ksp.com.intellij.psi.impl.PsiManagerImpl;
import ksp.org.jetbrains.annotations.NotNull;

public final class PsiEventWrapperAspect implements PomModelAspect {
  private final @NotNull TreeAspect myTreeAspect;

  public PsiEventWrapperAspect(@NotNull TreeAspect treeAspect) {
    myTreeAspect = treeAspect;
  }

  @Override
  public void update(@NotNull PomModelEvent event) {
    TreeChangeEventImpl changeSet = (TreeChangeEventImpl)event.getChangeSet(myTreeAspect);
    if(changeSet == null) return;

    PsiFile file = (PsiFile)changeSet.getRootElement().getPsi();

    ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject())).getSynchronizer().processEvents(changeSet, file);

    if (PomModelImpl.shouldFirePhysicalPsiEvents(file)) {
      changeSet.fireEvents();
    }
    else {
      ((PsiManagerImpl)file.getManager()).afterChange(false);
    }
  }

}
