// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.command;

import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.NlsContexts;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class CommandProcessorEx extends CommandProcessor {
  public abstract void enterModal();
  public abstract void leaveModal();

  public abstract @Nullable CommandToken startCommand(@Nullable Project project, @NlsContexts.Command String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy);

  public abstract void finishCommand(final @NotNull CommandToken command, @Nullable Throwable throwable);
}
