// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.navigation;

import ksp.com.intellij.model.Symbol;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.platform.backend.navigation.NavigationTarget;
import ksp.org.jetbrains.annotations.ApiStatus.Experimental;
import ksp.org.jetbrains.annotations.ApiStatus.OverrideOnly;
import ksp.org.jetbrains.annotations.NotNull;

import java.util.Collection;

/**
 * Implement this interface in the {@link Symbol} to provide navigation targets.
 *
 * @see SymbolNavigationProvider
 */
@Experimental
@OverrideOnly
public interface NavigatableSymbol extends Symbol {

  @NotNull
  Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project);
}
