// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.mock;

import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.impl.ResolveScopeManager;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.org.jetbrains.annotations.NotNull;


public class MockResolveScopeManager extends ResolveScopeManager {
  private final Project myProject;

  public MockResolveScopeManager(Project project) {
    myProject = project;
  }

  @Override
  public @NotNull GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
    return GlobalSearchScope.allScope(element.getProject());
  }

  @Override
  public @NotNull GlobalSearchScope getDefaultResolveScope(@NotNull VirtualFile vFile) {
    return GlobalSearchScope.allScope(myProject);
  }

  @Override
  public @NotNull GlobalSearchScope getUseScope(@NotNull PsiElement element) {
    return GlobalSearchScope.allScope(element.getProject());
  }
}
