/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCNameUtilities;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import ksp.org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "validFirstChars", "", "", "validChars", "checkObjCName", "objCName", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameUtilities$ObjCName;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n37#2:87\n1869#3,2:88\n1#4:90\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker\n*L\n42#1:87\n47#1:88,2\n*E\n"})
public final class FirNativeObjCNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeObjCNameChecker INSTANCE = new FirNativeObjCNameChecker();
    @NotNull
    private static final Set<Character> validFirstChars = SetsKt.plus((Set)SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('a', 'z')))), (Object)Character.valueOf('_'));
    @NotNull
    private static final Set<Character> validChars = SetsKt.plus(validFirstChars, (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('0', '9'))));

    private FirNativeObjCNameChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2 instanceof FirValueParameter) {
            return;
        }
        List objCNames = CollectionsKt.filterNotNull((Iterable)FirNativeObjCNameUtilities.INSTANCE.getObjCNames(declaration2.getSymbol(), context2.getSession()));
        if (objCNames.isEmpty()) {
            return;
        }
        if (declaration2 instanceof FirCallableDeclaration) {
            FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                for (FirNativeObjCNameUtilities.ObjCName objCName : objCNames) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)objCName.getAnnotation().getSource(), FirNativeErrors.INSTANCE.getINAPPLICABLE_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
        Iterable $this$forEach$iv = objCNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirNativeObjCNameUtilities.ObjCName it = (FirNativeObjCNameUtilities.ObjCName)element$iv;
            boolean bl2 = false;
            INSTANCE.checkObjCName(it, declaration2, context2, reporter);
        }
    }

    private final void checkObjCName(FirNativeObjCNameUtilities.ObjCName objCName, FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        Object invalidSwiftNameChars;
        Set invalidChars;
        Object object;
        Object invalidNameChars;
        Object object2;
        Set invalidFirstChars;
        KtSourceElement annotationSource;
        block16: {
            block15: {
                Object object3;
                Object object4;
                Object[] invalidNameFirstChar;
                Object object5;
                Object object6;
                Object[] objectArray;
                Object[] objectArray2;
                annotationSource = objCName.getAnnotation().getSource();
                Iterator<Map.Entry<Name, FirExpression>> iterator2 = objCName.getAnnotation().getArgumentMapping().getMapping().entrySet().iterator();
                while (iterator2.hasNext()) {
                    FirExpression argument = iterator2.next().getValue();
                    if (argument instanceof FirLiteralExpression) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument.getSource(), FirNativeErrors.INSTANCE.getNON_LITERAL_OBJC_NAME_ARG(), (DiagnosticContext)context2, null, 8, null);
                }
                if (objCName.getName() == null && objCName.getSwiftName() == null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
                }
                if ((objectArray2 = objCName.getName()) != null && (objectArray2 = StringsKt.firstOrNull((CharSequence)((CharSequence)objectArray2))) != null) {
                    objectArray = objectArray2;
                    object6 = validFirstChars;
                    char p0 = objectArray.charValue();
                    boolean bl2 = false;
                    object5 = !object6.contains(Character.valueOf(p0)) ? objectArray : null;
                } else {
                    object5 = invalidNameFirstChar = null;
                }
                if ((object4 = objCName.getSwiftName()) != null && (object4 = StringsKt.firstOrNull((CharSequence)((CharSequence)object4))) != null) {
                    object6 = object4;
                    Set<Character> p0 = validFirstChars;
                    char p02 = ((Character)object6).charValue();
                    boolean bl3 = false;
                    object3 = !p0.contains(Character.valueOf(p02)) ? object6 : null;
                } else {
                    object3 = null;
                }
                Object invalidSwiftNameFirstChar = object3;
                objectArray = new Character[]{invalidNameFirstChar, invalidSwiftNameFirstChar};
                invalidFirstChars = SetsKt.setOfNotNull((Object[])objectArray);
                if (!((Collection)invalidFirstChars).isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME_FIRST_CHAR(), (Object)CollectionsKt.joinToString$default((Iterable)invalidFirstChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (DiagnosticContext)context2, null, 16, null);
                }
                String string = objCName.getName();
                if (string != null ? ((CharSequence)string).length() == 0 : false) break block15;
                String string2 = objCName.getSwiftName();
                boolean bl4 = string2 != null ? ((CharSequence)string2).length() == 0 : false;
                if (!bl4) break block16;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getEMPTY_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
        if ((object2 = objCName.getName()) == null || (object2 = StringsKt.toSet((CharSequence)((CharSequence)object2))) == null || (object2 = CollectionsKt.subtract((Iterable)((Iterable)object2), (Iterable)validChars)) == null) {
            object2 = invalidNameChars = SetsKt.emptySet();
        }
        if ((object = objCName.getSwiftName()) == null || (object = StringsKt.toSet((CharSequence)((CharSequence)object))) == null || (object = CollectionsKt.subtract((Iterable)((Iterable)object), (Iterable)validChars)) == null) {
            object = SetsKt.emptySet();
        }
        if (!((Collection)(invalidChars = SetsKt.plus((Set)invalidNameChars, (Iterable)((Iterable)(invalidSwiftNameChars = object))))).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME_CHARS(), (Object)CollectionsKt.joinToString$default((Iterable)invalidFirstChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (DiagnosticContext)context2, null, 16, null);
        }
        if (objCName.getExact() && (!(declaration2 instanceof FirClass) || ((FirClass)declaration2).getClassKind() == ClassKind.ENUM_ENTRY)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINAPPLICABLE_EXACT_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
        if (objCName.getExact() && objCName.getName() == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getMISSING_EXACT_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

