/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeIdentityHashCodeCallOnValueTypeObjectChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "identityHashCodeCallableId", "Lksp/org/jetbrains/kotlin/name/CallableId;", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
public final class FirNativeIdentityHashCodeCallOnValueTypeObjectChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirNativeIdentityHashCodeCallOnValueTypeObjectChecker INSTANCE = new FirNativeIdentityHashCodeCallOnValueTypeObjectChecker();
    @NotNull
    private static final CallableId identityHashCodeCallableId;

    private FirNativeIdentityHashCodeCallOnValueTypeObjectChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> symbol = firCallableSymbol;
        if (!Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)identityHashCodeCallableId)) {
            return;
        }
        Object object = expression2.getExtensionReceiver();
        if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null) {
            return;
        }
        Object argumentType = object;
        if (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive((ConeKotlinType)argumentType) || FirHelpersKt.isValueClass((ConeKotlinType)argumentType, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirNativeErrors.INSTANCE.getIDENTITY_HASH_CODE_ON_VALUE_TYPE(), argumentType, (DiagnosticContext)context2, null, 16, null);
        }
    }

    static {
        FqName fqName = new FqName("kotlin.native");
        Name name2 = Name.identifier("identityHashCode");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        identityHashCodeCallableId = new CallableId(fqName, name2);
    }
}

