/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression.FirJavaValueBasedClassUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeRigidType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmIdentitySensitiveCallWithValueTypeObjectChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "synchronizedCallableId", "Lksp/org/jetbrains/kotlin/name/CallableId;", "lockParameterName", "Lksp/org/jetbrains/kotlin/name/Name;", "operationsToCheckFirstArgCallableIds", "", "operationsToCheckFirstTypeArgCallableIds", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSynchronizedCall", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmIdentitySensitiveCallWithValueTypeObjectChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmIdentitySensitiveCallWithValueTypeObjectChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmIdentitySensitiveCallWithValueTypeObjectChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,95:1\n46#2:96\n48#2:97\n60#2,4:98\n*S KotlinDebug\n*F\n+ 1 FirJvmIdentitySensitiveCallWithValueTypeObjectChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmIdentitySensitiveCallWithValueTypeObjectChecker\n*L\n58#1:96\n61#1:97\n83#1:98,4\n*E\n"})
public final class FirJvmIdentitySensitiveCallWithValueTypeObjectChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJvmIdentitySensitiveCallWithValueTypeObjectChecker INSTANCE = new FirJvmIdentitySensitiveCallWithValueTypeObjectChecker();
    @NotNull
    private static final CallableId synchronizedCallableId;
    @NotNull
    private static final Name lockParameterName;
    @NotNull
    private static final Set<CallableId> operationsToCheckFirstArgCallableIds;
    @NotNull
    private static final Set<CallableId> operationsToCheckFirstTypeArgCallableIds;

    private FirJvmIdentitySensitiveCallWithValueTypeObjectChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol function2 = firCallableSymbol;
        CallableId callableId = function2.getCallableId();
        if (Intrinsics.areEqual((Object)callableId, (Object)synchronizedCallableId)) {
            this.checkSynchronizedCall(expression2, context2, reporter);
        } else if (operationsToCheckFirstArgCallableIds.contains(callableId)) {
            FirCall $this$arguments$iv = expression2;
            boolean $i$f$getArguments = false;
            Object object = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
            if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null) {
                return;
            }
            Object type2 = object;
            if (FirJavaValueBasedClassUtilsKt.isValueTypeAndWarningsEnabled((ConeKotlinType)type2, context2.getSession())) {
                FirCall $this$argument$iv = expression2;
                boolean $i$f$getArgument = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments())).getSource(), FirJvmErrors.INSTANCE.getIDENTITY_SENSITIVE_OPERATIONS_WITH_VALUE_TYPE(), type2, (DiagnosticContext)context2, null, 16, null);
            }
        } else if (operationsToCheckFirstTypeArgCallableIds.contains(callableId)) {
            Object object = CollectionsKt.firstOrNull(expression2.getTypeArguments());
            FirTypeProjectionWithVariance firTypeProjectionWithVariance = object instanceof FirTypeProjectionWithVariance ? (FirTypeProjectionWithVariance)object : null;
            if (firTypeProjectionWithVariance == null) {
                return;
            }
            FirTypeProjectionWithVariance typeArgument = firTypeProjectionWithVariance;
            ConeRigidType type3 = ConeTypeUtilsKt.upperBoundIfFlexible(FirTypeUtilsKt.getConeType(typeArgument.getTypeRef()));
            if (FirJavaValueBasedClassUtilsKt.isValueTypeAndWarningsEnabled(type3, context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeArgument.getSource(), FirJvmErrors.INSTANCE.getIDENTITY_SENSITIVE_OPERATIONS_WITH_VALUE_TYPE(), (Object)type3, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    private final void checkSynchronizedCall(FirFunctionCall expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirCall $this$resolvedArgumentMapping$iv = expression2;
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
        Object object = linkedHashMap;
        if (linkedHashMap == null || (object = ((LinkedHashMap)object).entrySet()) == null) {
            return;
        }
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            FirExpression argument = (FirExpression)entry.getKey();
            FirValueParameter parameter2 = (FirValueParameter)entry.getValue();
            if (!Intrinsics.areEqual((Object)parameter2.getName(), (Object)lockParameterName)) continue;
            ConeKotlinType type2 = FirTypeUtilsKt.getResolvedType(argument);
            if (ConeBuiltinTypeUtilsKt.isPrimitive(type2) || FirHelpersKt.isValueClass(type2, context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_BLOCK_ON_VALUE_CLASS_OR_PRIMITIVE(), (Object)type2, (DiagnosticContext)context2, null, 16, null);
            }
            if (!FirJavaValueBasedClassUtilsKt.isJavaValueBasedClassAndWarningsEnabled(type2, context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_BLOCK_ON_JAVA_VALUE_BASED_CLASS(), (Object)type2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    static {
        FqName fqName = new FqName("kotlin");
        Name name2 = Name.identifier("synchronized");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        synchronizedCallableId = new CallableId(fqName, name2);
        Name name3 = Name.identifier("lock");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        lockParameterName = name3;
        Object[] objectArray = new CallableId[5];
        FqName fqName2 = new FqName("java.lang");
        FqName fqName3 = new FqName("System");
        Name name4 = Name.identifier("identityHashCode");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        objectArray[0] = new CallableId(fqName2, fqName3, name4);
        FqName fqName4 = new FqName("java.lang.ref");
        FqName fqName5 = new FqName("Cleaner");
        Name name5 = Name.identifier("register");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
        objectArray[1] = new CallableId(fqName4, fqName5, name5);
        FqName fqName6 = new FqName("java.lang.ref");
        FqName fqName7 = new FqName("PhantomReference");
        Name name6 = Name.identifier("PhantomReference");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"identifier(...)");
        objectArray[2] = new CallableId(fqName6, fqName7, name6);
        FqName fqName8 = new FqName("java.lang.ref");
        FqName fqName9 = new FqName("SoftReference");
        Name name7 = Name.identifier("SoftReference");
        Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"identifier(...)");
        objectArray[3] = new CallableId(fqName8, fqName9, name7);
        FqName fqName10 = new FqName("java.lang.ref");
        FqName fqName11 = new FqName("WeakReference");
        Name name8 = Name.identifier("WeakReference");
        Intrinsics.checkNotNullExpressionValue((Object)name8, (String)"identifier(...)");
        objectArray[4] = new CallableId(fqName10, fqName11, name8);
        operationsToCheckFirstArgCallableIds = SetsKt.setOf((Object[])objectArray);
        objectArray = new CallableId[2];
        FqName fqName12 = new FqName("java.util");
        FqName fqName13 = new FqName("IdentityHashMap");
        Name name9 = Name.identifier("IdentityHashMap");
        Intrinsics.checkNotNullExpressionValue((Object)name9, (String)"identifier(...)");
        objectArray[0] = new CallableId(fqName12, fqName13, name9);
        FqName fqName14 = new FqName("java.util");
        FqName fqName15 = new FqName("WeakHashMap");
        Name name10 = Name.identifier("WeakHashMap");
        Intrinsics.checkNotNullExpressionValue((Object)name10, (String)"identifier(...)");
        objectArray[1] = new CallableId(fqName14, fqName15, name10);
        operationsToCheckFirstTypeArgCallableIds = SetsKt.setOf((Object[])objectArray);
    }
}

