/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.java.enhancement.InheritedKtPrivateClassDataKeyKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJavaClassInheritsKtPrivateClassDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirJavaClassInheritsKtPrivateClassDeclarationChecker
extends FirDeclarationChecker<FirConstructor> {
    @NotNull
    public static final FirJavaClassInheritsKtPrivateClassDeclarationChecker INSTANCE = new FirJavaClassInheritsKtPrivateClassDeclarationChecker();

    private FirJavaClassInheritsKtPrivateClassDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirConstructor declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitJavaClassInheritingPrivateKotlinClass)) {
            return;
        }
        FirDelegatedConstructorCall firDelegatedConstructorCall = declaration2.getDelegatedConstructor();
        if (firDelegatedConstructorCall == null) {
            return;
        }
        FirDelegatedConstructorCall delegatedConstructorCall = firDelegatedConstructorCall;
        FirConstructorSymbol firConstructorSymbol = declaration2.getSymbol().getResolvedDelegatedConstructor();
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol resolvedDelegatedConstructor = firConstructorSymbol;
        ConeKotlinType inheritedKtPrivateCls = InheritedKtPrivateClassDataKeyKt.getInheritedKtPrivateCls(resolvedDelegatedConstructor);
        if (inheritedKtPrivateCls != null) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(resolvedDelegatedConstructor);
            Intrinsics.checkNotNull((Object)coneClassLikeLookupTag);
            ClassId javaClassId = coneClassLikeLookupTag.getClassId();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)delegatedConstructorCall.getSource(), FirJvmErrors.INSTANCE.getJAVA_CLASS_INHERITS_KT_PRIVATE_CLASS(), (Object)javaClassId, (Object)inheritedKtPrivateCls, (DiagnosticContext)context2, null, 32, null);
        }
    }
}

