/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakePsiSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtLightSourceElement;
import ksp.org.jetbrains.kotlin.KtPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtRealPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElementKt;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtTypeProjection;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnderscoredTypeArgumentSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lksp/com/intellij/psi/PsiElement;", "<init>", "()V", "isApplicable", "", "element", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "MESSAGE", "", "checkPsi", "", "Lksp/org/jetbrains/kotlin/KtPsiSourceElement;", "psi", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkLightTree", "Lksp/org/jetbrains/kotlin/KtLightSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnderscoredTypeArgumentSyntaxChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnderscoredTypeArgumentSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnderscoredTypeArgumentSyntaxChecker\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,71:1\n879#2,5:72\n*S KotlinDebug\n*F\n+ 1 FirUnderscoredTypeArgumentSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirUnderscoredTypeArgumentSyntaxChecker\n*L\n42#1:72,5\n*E\n"})
public final class FirUnderscoredTypeArgumentSyntaxChecker
extends FirExpressionSyntaxChecker<FirFunctionCall, PsiElement> {
    @NotNull
    public static final FirUnderscoredTypeArgumentSyntaxChecker INSTANCE = new FirUnderscoredTypeArgumentSyntaxChecker();
    @NotNull
    private static final String MESSAGE = "Underscore type arguments cannot be annotated.";

    private FirUnderscoredTypeArgumentSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirFunctionCall element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return !((Collection)element2.getTypeArguments()).isEmpty();
    }

    @Override
    public void checkPsi(@NotNull FirFunctionCall element2, @NotNull KtPsiSourceElement source, @NotNull PsiElement psi, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeProjection typeProjection : element2.getTypeArguments()) {
            KtTypeReference typeReference;
            KtTypeProjection psiTypeArgument;
            KtSourceElement ktSourceElement = typeProjection.getSource();
            PsiElement psiElement = ktSourceElement != null ? KtSourceElementKt.getPsi(ktSourceElement) : null;
            KtTypeProjection ktTypeProjection = psiElement instanceof KtTypeProjection ? (KtTypeProjection)psiElement : null;
            if (ktTypeProjection == null || (psiTypeArgument = ktTypeProjection).getTypeReference() == null || !typeReference.isPlaceholder()) continue;
            for (KtAnnotationEntry annotation : typeReference.getAnnotationEntries()) {
                KtPsiSourceElement ktPsiSourceElement;
                PsiElement $this$toKtPsiSourceElement_u24default$iv = annotation;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                boolean $i$f$toKtPsiSourceElement = false;
                KtSourceElementKind ktSourceElementKind = kind$iv;
                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv);
                } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                    ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktPsiSourceElement, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)MESSAGE, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    @Override
    public void checkLightTree(@NotNull FirFunctionCall element2, @NotNull KtLightSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeProjection typeProjection : element2.getTypeArguments()) {
            List<LighterASTNode> annotations2;
            Object object = typeProjection.getSource();
            if (object == null || (object = ((KtSourceElement)object).getLighterASTNode()) == null) continue;
            Object lightTreeTypeArgument = object;
            if (!FirUnderscoreHelpersKt.isUnderscore(String.valueOf(LightTreePositioningStrategiesKt.userType(source.getTreeStructure(), (LighterASTNode)lightTreeTypeArgument))) || LightTreePositioningStrategiesKt.annotations(source.getTreeStructure(), (LighterASTNode)lightTreeTypeArgument) == null) continue;
            for (LighterASTNode annotation : annotations2) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)FirSourceUtilsKt.buildChildSourceElement(source, annotation), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)MESSAGE, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }
}

