/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirUnitExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionReturnTypeMismatchChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirFunctionReturnTypeMismatchChecker
extends FirExpressionChecker<FirReturnExpression> {
    @NotNull
    public static final FirFunctionReturnTypeMismatchChecker INSTANCE = new FirFunctionReturnTypeMismatchChecker();

    private FirFunctionReturnTypeMismatchChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirReturnExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeKotlinType returnExpressionType;
        ConeInferenceContext typeContext2;
        ConeKotlinType functionReturnType;
        FirExpression resultExpression;
        FirFunction targetElement;
        block15: {
            block16: {
                KtSourceElementKind sourceKind;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                KtSourceElement ktSourceElement = expression2.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                    return;
                }
                targetElement = expression2.getTarget().getLabeledElement();
                if (targetElement instanceof FirErrorFunction) {
                    return;
                }
                KtSourceElement ktSourceElement2 = expression2.getSource();
                KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement2 != null ? ktSourceElement2.getKind() : null;
                if (!(DeclarationUtilsKt.getHasExplicitReturnType((FirCallableSymbol)targetElement.getSymbol()) || Intrinsics.areEqual((Object)sourceKind, (Object)KtRealSourceElementKind.INSTANCE) || targetElement instanceof FirPropertyAccessor)) {
                    return;
                }
                resultExpression = expression2.getResult();
                if (resultExpression instanceof FirWhenExpression && !ExhaustivenessStatusKt.isExhaustive((FirWhenExpression)resultExpression)) {
                    return;
                }
                ConeKotlinType coneKotlinType = functionReturnType = targetElement instanceof FirConstructor ? (ConeKotlinType)context2.getSession().getBuiltinTypes().getUnitType().getConeType() : TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(targetElement.getReturnTypeRef()), context2.getSession(), null, 2, null);
                if (!(targetElement instanceof FirAnonymousFunction)) break block15;
                if (sourceKind instanceof KtFakeSourceElementKind.ImplicitReturn.FromLastStatement && ConeBuiltinTypeUtilsKt.isUnit(functionReturnType)) {
                    return;
                }
                if (!((FirAnonymousFunction)targetElement).isLambda()) break block15;
                if (ConeBuiltinTypeUtilsKt.isUnit(functionReturnType)) break block15;
                if (!(resultExpression instanceof FirUnitExpression)) break block16;
                KtSourceElement ktSourceElement3 = ((FirUnitExpression)resultExpression).getSource();
                if ((ktSourceElement3 != null ? ktSourceElement3.getKind() : null) instanceof KtFakeSourceElementKind.ImplicitUnit) break block15;
            }
            return;
        }
        if (!FirHelpersKt.isSubtypeForTypeMismatch(typeContext2 = TypeComponentsKt.getTypeContext(context2.getSession()), returnExpressionType = FirTypeUtilsKt.getResolvedType(resultExpression), functionReturnType)) {
            if (FirTypeUtilsKt.isNullLiteral(resultExpression) && !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(functionReturnType)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression.getSource(), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), (Object)functionReturnType, (DiagnosticContext)context2, null, 16, null);
            } else {
                boolean isDueToNullability = InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context2.getSession()), returnExpressionType, functionReturnType);
                if (resultExpression instanceof FirSmartCastExpression && !((FirSmartCastExpression)resultExpression).isStable() && FirHelpersKt.isSubtypeForTypeMismatch(typeContext2, FirTypeUtilsKt.getConeType(((FirSmartCastExpression)resultExpression).getSmartcastType()), functionReturnType)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirSmartCastExpression)resultExpression).getSource(), FirErrors.INSTANCE.getSMARTCAST_IMPOSSIBLE(), (Object)functionReturnType, (Object)resultExpression, (Object)((FirSmartCastExpression)resultExpression).getSmartcastStability().getDescription(), (Object)isDueToNullability, (DiagnosticContext)context2, null, 128, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH(), (Object)functionReturnType, (Object)returnExpressionType, (Object)targetElement, (Object)isDueToNullability, (DiagnosticContext)context2, null, 128, null);
                }
            }
        } else {
            KtSourceElement ktSourceElement = resultExpression.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ImplicitUnit && !ConeBuiltinTypeUtilsKt.isUnit(ConeTypeUtilsKt.lowerBoundIfFlexible(TypeExpansionUtilsKt.fullyExpandedType$default(functionReturnType, context2.getSession(), null, 2, null)))) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultExpression.getSource(), FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH(), (Object)functionReturnType, (Object)returnExpressionType, (Object)targetElement, (Object)false, (DiagnosticContext)context2, null, 128, null);
            }
        }
    }
}

