/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.ArgumentInfo;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirTypeCompatibilityHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.TypeInfo;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirEqualityCompatibilityCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirOperation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J!\u0010\u0014\u001a\u00020\u0007*\u00020\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\u0016H\u0082\bJ\"\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J4\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J4\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002JT\u0010%\u001a\u00020\u0007*\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006/"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityOperatorCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkEqualityApplicability", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker$Applicability;", "l", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "r", "checkIdentityApplicability", "getInapplicabilityFor", "ifInapplicable", "block", "Lkotlin/Function1;", "getGeneralInapplicabilityDiagnostic", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "forceWarning", "", "getIdentityLessInapplicabilityDiagnostic", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactory2;", "isIdentityComparedWithImplicitBoxing", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "arePrimitiveAndNonPrimitiveSupertypeRespectively", "getSourceLessInapplicabilityDiagnostic", "getEnumInapplicabilityDiagnostic", "reportInapplicabilityDiagnostic", "applicability", "operation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirOperation;", "lUserType", "rUserType", "checkSenselessness", "lType", "rType", "Applicability", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirEqualityCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirEqualityCompatibilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n124#1,4:296\n124#1,4:300\n1#2:295\n*S KotlinDebug\n*F\n+ 1 FirEqualityCompatibilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker\n*L\n39#1:296,4\n62#1:300,4\n*E\n"})
public final class FirEqualityCompatibilityChecker
extends FirExpressionChecker<FirEqualityOperatorCall> {
    @NotNull
    public static final FirEqualityCompatibilityChecker INSTANCE = new FirEqualityCompatibilityChecker();

    private FirEqualityCompatibilityChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirEqualityOperatorCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        List<FirExpression> arguments2 = expression2.getArgumentList().getArguments();
        if (!(arguments2.size() == 2)) {
            boolean $i$a$-require-FirEqualityCompatibilityChecker$check$22 = false;
            String $i$a$-require-FirEqualityCompatibilityChecker$check$22 = "Equality operator call with non-2 arguments";
            throw new IllegalArgumentException($i$a$-require-FirEqualityCompatibilityChecker$check$22.toString());
        }
        ArgumentInfo l2 = FirTypeCompatibilityHelpersKt.toArgumentInfo(arguments2.get(0), context2);
        ArgumentInfo r2 = FirTypeCompatibilityHelpersKt.toArgumentInfo(arguments2.get(1), context2);
        this.checkSenselessness(l2.getSmartCastType(), r2.getSmartCastType(), context2, expression2, reporter);
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                kFunction = (KFunction)new Function3<TypeInfo, TypeInfo, CheckerContext, Applicability>((Object)this){

                    public final Applicability invoke(TypeInfo p0, TypeInfo p1, CheckerContext p2) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        return FirEqualityCompatibilityChecker.access$checkEqualityApplicability((FirEqualityCompatibilityChecker)this.receiver, p0, p1, p2);
                    }
                };
                break;
            }
            case 3: 
            case 4: {
                kFunction = (KFunction)new Function3<TypeInfo, TypeInfo, CheckerContext, Applicability>((Object)this){

                    public final Applicability invoke(TypeInfo p0, TypeInfo p1, CheckerContext p2) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        return FirEqualityCompatibilityChecker.access$checkIdentityApplicability((FirEqualityCompatibilityChecker)this.receiver, p0, p1, p2);
                    }
                };
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operator of FirEqualityOperatorCall".toString());
            }
        }
        KFunction checkApplicability2 = kFunction;
        FirEqualityCompatibilityChecker firEqualityCompatibilityChecker = this;
        Applicability $this$ifInapplicable$iv = (Applicability)((Object)((Function3)checkApplicability2).invoke((Object)l2.getOriginalTypeInfo(), (Object)r2.getOriginalTypeInfo(), (Object)context2));
        boolean $i$f$ifInapplicable = false;
        if (WhenMappings.$EnumSwitchMapping$1[$this$ifInapplicable$iv.ordinal()] != 1) {
            Applicability it = $this$ifInapplicable$iv;
            boolean bl2 = false;
            boolean isCaseMissedByK1 = FirEqualityCompatibilityCheckerKt.isCaseMissedByK1Intersector(l2.getOriginalTypeInfo(), r2.getOriginalTypeInfo()) && FirEqualityCompatibilityCheckerKt.isCaseMissedByAdditionalK1IncompatibleEnumsCheck(l2.getOriginalType(), r2.getOriginalType(), context2.getSession());
            boolean replicateK1Behavior = !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReportErrorsForComparisonOperators);
            INSTANCE.reportInapplicabilityDiagnostic(reporter, expression2, it, expression2.getOperation(), isCaseMissedByK1 && replicateK1Behavior, l2.getOriginalTypeInfo(), r2.getOriginalTypeInfo(), l2.getUserType(), r2.getUserType(), context2);
            return;
        }
        if (!(l2.getArgument() instanceof FirSmartCastExpression) && !(r2.getArgument() instanceof FirSmartCastExpression)) {
            return;
        }
        FirEqualityCompatibilityChecker this_$iv = this;
        $this$ifInapplicable$iv = (Applicability)((Object)((Function3)checkApplicability2).invoke((Object)l2.getSmartCastTypeInfo(), (Object)r2.getSmartCastTypeInfo(), (Object)context2));
        $i$f$ifInapplicable = false;
        if (WhenMappings.$EnumSwitchMapping$1[$this$ifInapplicable$iv.ordinal()] != 1) {
            Applicability it = $this$ifInapplicable$iv;
            boolean bl3 = false;
            INSTANCE.reportInapplicabilityDiagnostic(reporter, expression2, it, expression2.getOperation(), true, l2.getSmartCastTypeInfo(), r2.getSmartCastTypeInfo(), l2.getUserType(), r2.getUserType(), context2);
            return;
        }
    }

    private final Applicability checkEqualityApplicability(TypeInfo l2, TypeInfo r2, CheckerContext context2) {
        boolean oneIsBuiltin = l2.isBuiltin() || r2.isBuiltin();
        boolean oneIsIdentityLess = FirTypeCompatibilityHelpersKt.isIdentityLess(l2, context2.getSession()) || FirTypeCompatibilityHelpersKt.isIdentityLess(r2, context2.getSession());
        return (oneIsBuiltin || oneIsIdentityLess) && FirTypeCompatibilityHelpersKt.shouldReportAsPerRules1(l2, r2, context2) ? this.getInapplicabilityFor(l2, r2) : Applicability.APPLICABLE;
    }

    private final Applicability checkIdentityApplicability(TypeInfo l2, TypeInfo r2, CheckerContext context2) {
        boolean oneIsNotNull = !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(l2.getType()) || !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(r2.getType());
        return ConeBuiltinTypeUtilsKt.isNullableNothing(l2.getType()) || ConeBuiltinTypeUtilsKt.isNullableNothing(r2.getType()) ? Applicability.APPLICABLE : (FirTypeCompatibilityHelpersKt.isIdentityLess(l2, context2.getSession()) || FirTypeCompatibilityHelpersKt.isIdentityLess(r2, context2.getSession()) ? Applicability.INAPPLICABLE_AS_IDENTITY_LESS : (oneIsNotNull && FirTypeCompatibilityHelpersKt.shouldReportAsPerRules1(l2, r2, context2) ? this.getInapplicabilityFor(l2, r2) : Applicability.APPLICABLE));
    }

    private final Applicability getInapplicabilityFor(TypeInfo l2, TypeInfo r2) {
        boolean isNonEmptyIntersectionInK1 = FirEqualityCompatibilityCheckerKt.isCaseMissedByK1Intersector(l2, r2);
        boolean isOneEnum = l2.isEnumClass() || r2.isEnumClass();
        return isNonEmptyIntersectionInK1 && isOneEnum ? Applicability.INAPPLICABLE_AS_ENUMS : Applicability.GENERALLY_INAPPLICABLE;
    }

    private final void ifInapplicable(Applicability $this$ifInapplicable, Function1<? super Applicability, Unit> block) {
        boolean $i$f$ifInapplicable = false;
        if (WhenMappings.$EnumSwitchMapping$1[$this$ifInapplicable.ordinal()] != 1) {
            block.invoke((Object)$this$ifInapplicable);
        }
    }

    private final KtDiagnosticFactory3<String, ConeKotlinType, ConeKotlinType> getGeneralInapplicabilityDiagnostic(boolean forceWarning) {
        return forceWarning ? FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE_WARNING() : FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE();
    }

    private final KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> getIdentityLessInapplicabilityDiagnostic(TypeInfo l2, TypeInfo r2, boolean forceWarning, CheckerContext context2) {
        boolean areBothPrimitives = FirTypeCompatibilityHelpersKt.isNotNullPrimitive(l2) && FirTypeCompatibilityHelpersKt.isNotNullPrimitive(r2);
        boolean areSameTypes = Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(l2.getType()), (Object)ConeTypeUtilsKt.getClassId(r2.getType()));
        boolean shouldProperlyReportError = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReportErrorsForComparisonOperators);
        boolean shouldRelaxDiagnostic = (l2.isPrimitive() || r2.isPrimitive()) && FirTypeCompatibilityHelpersKt.areRelated(l2, r2, context2) && !shouldProperlyReportError;
        return areSameTypes && areBothPrimitives ? FirErrors.INSTANCE.getDEPRECATED_IDENTITY_EQUALS() : (this.isIdentityComparedWithImplicitBoxing(l2, r2, context2.getSession()) ? FirErrors.INSTANCE.getIMPLICIT_BOXING_IN_IDENTITY_EQUALS() : (forceWarning || shouldRelaxDiagnostic ? FirErrors.INSTANCE.getFORBIDDEN_IDENTITY_EQUALS_WARNING() : FirErrors.INSTANCE.getFORBIDDEN_IDENTITY_EQUALS()));
    }

    private final boolean isIdentityComparedWithImplicitBoxing(TypeInfo l2, TypeInfo r2, FirSession session) {
        return this.arePrimitiveAndNonPrimitiveSupertypeRespectively(l2, r2, session) || this.arePrimitiveAndNonPrimitiveSupertypeRespectively(r2, l2, session);
    }

    private final boolean arePrimitiveAndNonPrimitiveSupertypeRespectively(TypeInfo l2, TypeInfo r2, FirSession session) {
        return FirTypeCompatibilityHelpersKt.isNotNullPrimitive(l2) && !FirTypeCompatibilityHelpersKt.isNotNullPrimitive(r2) && TypeUtilsKt.isSubtypeOf$default(l2.getType(), r2.getType(), session, false, 4, null);
    }

    private final KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> getSourceLessInapplicabilityDiagnostic(boolean forceWarning) {
        return forceWarning ? FirErrors.INSTANCE.getINCOMPATIBLE_TYPES_WARNING() : FirErrors.INSTANCE.getINCOMPATIBLE_TYPES();
    }

    private final KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> getEnumInapplicabilityDiagnostic(TypeInfo l2, TypeInfo r2, boolean forceWarning, CheckerContext context2) {
        boolean isOldTestData = !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitComparisonOfIncompatibleEnums);
        boolean bothNullableEnums = FirTypeCompatibilityHelpersKt.isNullableEnum(l2) && FirTypeCompatibilityHelpersKt.isNullableEnum(r2);
        boolean areIntersectionsInvolved = l2.getType() instanceof ConeIntersectionType || r2.getType() instanceof ConeIntersectionType;
        boolean shouldProperlyReportError = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReportErrorsForComparisonOperators);
        boolean shouldRelaxDiagnostic = (bothNullableEnums || areIntersectionsInvolved) && !shouldProperlyReportError;
        return forceWarning || isOldTestData || shouldRelaxDiagnostic ? FirErrors.INSTANCE.getINCOMPATIBLE_ENUM_COMPARISON() : FirErrors.INSTANCE.getINCOMPATIBLE_ENUM_COMPARISON_ERROR();
    }

    private final void reportInapplicabilityDiagnostic(DiagnosticReporter $this$reportInapplicabilityDiagnostic, FirEqualityOperatorCall expression2, Applicability applicability, FirOperation operation, boolean forceWarning, TypeInfo l2, TypeInfo r2, ConeKotlinType lUserType, ConeKotlinType rUserType, CheckerContext context2) {
        if (applicability == Applicability.INAPPLICABLE_AS_IDENTITY_LESS) {
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getSource(), this.getIdentityLessInapplicabilityDiagnostic(l2, r2, forceWarning, context2), (Object)lUserType, (Object)rUserType, (DiagnosticContext)context2, null, 32, null);
        } else if (applicability == Applicability.INAPPLICABLE_AS_ENUMS) {
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getSource(), this.getEnumInapplicabilityDiagnostic(l2, r2, forceWarning, context2), (Object)lUserType, (Object)rUserType, (DiagnosticContext)context2, null, 32, null);
        } else {
            KtSourceElement ktSourceElement = expression2.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getSource(), this.getSourceLessInapplicabilityDiagnostic(forceWarning), (Object)lUserType, (Object)rUserType, (DiagnosticContext)context2, null, 32, null);
            } else if (applicability == Applicability.GENERALLY_INAPPLICABLE) {
                KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression2.getSource(), this.getGeneralInapplicabilityDiagnostic(forceWarning), (Object)operation.getOperator(), (Object)lUserType, (Object)rUserType, (DiagnosticContext)context2, null, 64, null);
            } else {
                throw new IllegalStateException("Shouldn't be here".toString());
            }
        }
    }

    private final void checkSenselessness(ConeKotlinType lType, ConeKotlinType rType, CheckerContext context2, FirEqualityOperatorCall expression2, DiagnosticReporter reporter) {
        boolean bl2;
        ConeKotlinType coneKotlinType;
        if (ConeBuiltinTypeUtilsKt.isNullableNothing(rType)) {
            coneKotlinType = lType;
        } else if (ConeBuiltinTypeUtilsKt.isNullableNothing(lType)) {
            coneKotlinType = rType;
        } else {
            return;
        }
        ConeKotlinType type2 = coneKotlinType;
        if (type2 instanceof ConeErrorType) {
            return;
        }
        boolean isPositiveCompare = expression2.getOperation() == FirOperation.EQ || expression2.getOperation() == FirOperation.IDENTITY;
        ConeInferenceContext $this$checkSenselessness_u24lambda_u243 = TypeComponentsKt.getTypeContext(context2.getSession());
        boolean bl3 = false;
        if (ConeBuiltinTypeUtilsKt.isNullableNothing(type2)) {
            bl2 = isPositiveCompare;
        } else if (!$this$checkSenselessness_u24lambda_u243.isNullableType(type2)) {
            bl2 = !isPositiveCompare;
        } else {
            return;
        }
        boolean compareResult = bl2;
        KtSourceElement ktSourceElement = expression2.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.BINARY_EXPRESSION) && type2 == lType && !compareResult) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSENSELESS_NULL_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSENSELESS_COMPARISON(), (Object)compareResult, (DiagnosticContext)context2, null, 16, null);
        }
    }

    public static final /* synthetic */ Applicability access$checkEqualityApplicability(FirEqualityCompatibilityChecker $this, TypeInfo l2, TypeInfo r2, CheckerContext context2) {
        return $this.checkEqualityApplicability(l2, r2, context2);
    }

    public static final /* synthetic */ Applicability access$checkIdentityApplicability(FirEqualityCompatibilityChecker $this, TypeInfo l2, TypeInfo r2, CheckerContext context2) {
        return $this.checkIdentityApplicability(l2, r2, context2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker$Applicability;", "", "<init>", "(Ljava/lang/String;I)V", "APPLICABLE", "GENERALLY_INAPPLICABLE", "INAPPLICABLE_AS_ENUMS", "INAPPLICABLE_AS_IDENTITY_LESS", "checkers"})
    private static final class Applicability
    extends Enum<Applicability> {
        public static final /* enum */ Applicability APPLICABLE = new Applicability();
        public static final /* enum */ Applicability GENERALLY_INAPPLICABLE = new Applicability();
        public static final /* enum */ Applicability INAPPLICABLE_AS_ENUMS = new Applicability();
        public static final /* enum */ Applicability INAPPLICABLE_AS_IDENTITY_LESS = new Applicability();
        private static final /* synthetic */ Applicability[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Applicability[] values() {
            return (Applicability[])$VALUES.clone();
        }

        public static Applicability valueOf(String value2) {
            return Enum.valueOf(Applicability.class, value2);
        }

        @NotNull
        public static EnumEntries<Applicability> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = applicabilityArray = new Applicability[]{Applicability.APPLICABLE, Applicability.GENERALLY_INAPPLICABLE, Applicability.INAPPLICABLE_AS_ENUMS, Applicability.INAPPLICABLE_AS_IDENTITY_LESS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.EQ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_EQ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.IDENTITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IDENTITY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Applicability.values().length];
            try {
                nArray[Applicability.APPLICABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

