/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirPureAbstractElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirUnusedCheckerBaseKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCatch;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLoop;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J2\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H&J\u001c\u0010\u0012\u001a\u00060\u0013R\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "isEnabled", "", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reportUnusedExpressionIfNeeded", "expression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "hasSideEffects", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "createVisitor", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase$UsageVisitorBase;", "check", "", "declaration", "UsageState", "UsageVisitorBase", "checkers"})
public abstract class FirUnusedCheckerBase
extends FirDeclarationChecker<FirDeclaration> {
    public FirUnusedCheckerBase() {
        super(MppCheckerKind.Common);
    }

    public abstract boolean isEnabled(@NotNull CheckerContext var1);

    public abstract boolean reportUnusedExpressionIfNeeded(@NotNull FirExpression var1, boolean var2, @NotNull CheckerContext var3, @NotNull DiagnosticReporter var4, @Nullable KtSourceElement var5);

    @NotNull
    protected UsageVisitorBase createVisitor(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        return new UsageVisitorBase(context2, reporter);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block4: {
            FirDeclaration firDeclaration;
            UsageVisitorBase visitor2;
            block7: {
                block6: {
                    block5: {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                            if (!this.isEnabled(context2)) {
                                return;
                            }
                            visitor2 = this.createVisitor(context2, reporter);
                            firDeclaration = declaration2;
                            if (!(firDeclaration instanceof FirReplSnippet)) break block3;
                            ((FirReplSnippet)declaration2).getBody().acceptChildren(visitor2, UsageState.Used);
                            break block4;
                        }
                        if (!(firDeclaration instanceof FirCodeFragment)) break block5;
                        ((FirCodeFragment)declaration2).getBlock().acceptChildren(visitor2, UsageState.Used);
                        break block4;
                    }
                    if (!(firDeclaration instanceof FirAnonymousInitializer)) break block6;
                    FirBlock firBlock = ((FirAnonymousInitializer)declaration2).getBody();
                    if (firBlock == null) break block4;
                    firBlock.acceptChildren(visitor2, UsageState.Unused);
                    break block4;
                }
                if (!(firDeclaration instanceof FirFunction)) break block7;
                boolean lastStatementUsed = declaration2 instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration2).isLambda();
                FirBlock firBlock = ((FirFunction)declaration2).getBody();
                if (firBlock == null) break block4;
                firBlock.accept(visitor2, lastStatementUsed ? UsageState.Used : UsageState.Unused);
                break block4;
            }
            if (!(firDeclaration instanceof FirVariable)) break block4;
            FirExpression firExpression = ((FirVariable)declaration2).getInitializer();
            if (firExpression != null) {
                firExpression.accept(visitor2, UsageState.Used);
            }
            FirExpression firExpression2 = ((FirVariable)declaration2).getDelegate();
            if (firExpression2 != null) {
                firExpression2.accept(visitor2, UsageState.Used);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase$UsageState;", "", "<init>", "(Ljava/lang/String;I)V", "Used", "Unused", "checkers"})
    protected static final class UsageState
    extends Enum<UsageState> {
        public static final /* enum */ UsageState Used = new UsageState();
        public static final /* enum */ UsageState Unused = new UsageState();
        private static final /* synthetic */ UsageState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UsageState[] values() {
            return (UsageState[])$VALUES.clone();
        }

        public static UsageState valueOf(String value2) {
            return Enum.valueOf(UsageState.class, value2);
        }

        @NotNull
        public static EnumEntries<UsageState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = usageStateArray = new UsageState[]{UsageState.Used, UsageState.Unused};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase$UsageVisitorBase;", "Lksp/org/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase$UsageState;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "visitElement", "element", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "data", "visitAnnotation", "annotation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "visitWhenExpression", "whenExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "visitTryExpression", "tryExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirTryExpression;", "visitBlock", "block", "Lksp/org/jetbrains/kotlin/fir/expressions/FirBlock;", "visitLoop", "loop", "Lksp/org/jetbrains/kotlin/fir/expressions/FirLoop;", "checkers"})
    protected class UsageVisitorBase
    extends FirDefaultVisitor<Unit, UsageState> {
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;

        public UsageVisitorBase(@NotNull CheckerContext context2, DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.context = context2;
            this.reporter = reporter;
        }

        @NotNull
        protected final CheckerContext getContext() {
            return this.context;
        }

        @NotNull
        protected final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @Override
        public void visitElement(@NotNull FirElement element2, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            if (element2 instanceof FirDeclaration) {
                return;
            }
            KtSourceElement source = element2.getSource();
            if (data == UsageState.Unused && element2 instanceof FirExpression && source != null && FirUnusedCheckerBase.this.reportUnusedExpressionIfNeeded((FirExpression)element2, FirUnusedCheckerBaseKt.access$hasSideEffect((FirExpression)element2), this.context, this.reporter, source)) {
                return;
            }
            element2.acceptChildren(this, UsageState.Used);
        }

        @Override
        public void visitAnnotation(@NotNull FirAnnotation annotation, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        }

        @Override
        public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            FirVariable variable = whenExpression.getSubjectVariable();
            if (variable == null) {
                FirPureAbstractElement firPureAbstractElement = whenExpression.getSubjectVariable();
                if (firPureAbstractElement != null && (firPureAbstractElement = ((FirVariable)firPureAbstractElement).getInitializer()) != null) {
                    ((FirExpression)firPureAbstractElement).accept(this, UsageState.Used);
                }
            } else {
                variable.accept(this, UsageState.Used);
            }
            for (FirWhenBranch branch : whenExpression.getBranches()) {
                branch.getCondition().accept(this, UsageState.Used);
                branch.getResult().accept(this, data);
            }
        }

        @Override
        public void visitTryExpression(@NotNull FirTryExpression tryExpression, @NotNull UsageState data) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)tryExpression, (String)"tryExpression");
                Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
                tryExpression.getTryBlock().accept(this, data);
                for (FirCatch firCatch : tryExpression.getCatches()) {
                    firCatch.getBlock().accept(this, data);
                }
                FirBlock firBlock = tryExpression.getFinallyBlock();
                if (firBlock == null) break block1;
                firBlock.accept(this, UsageState.Unused);
            }
        }

        @Override
        public void visitBlock(@NotNull FirBlock block, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            KtSourceElement ktSourceElement = block.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement) {
                return;
            }
            if (block instanceof FirContractCallBlock) {
                return;
            }
            List<FirStatement> statements = block.getStatements();
            int lastIndex = CollectionsKt.getLastIndex(statements);
            int n2 = ((Collection)statements).size();
            for (int i2 = 0; i2 < n2; ++i2) {
                FirStatement statement = statements.get(i2);
                boolean isImplicitReturn = i2 == lastIndex && statement instanceof FirExpression && TypeUtilsKt.isSubtypeOf$default(FirTypeUtilsKt.getResolvedType((FirExpression)statement), FirTypeUtilsKt.getResolvedType(block), this.context.getSession(), false, 4, null);
                statement.accept(this, isImplicitReturn ? data : UsageState.Unused);
            }
        }

        @Override
        public void visitLoop(@NotNull FirLoop loop, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            loop.getCondition().accept(this, UsageState.Used);
            loop.getBlock().accept(this, UsageState.Unused);
        }
    }
}

